/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.exception.ExceptionWrapper;
import com.tc.exception.ExceptionWrapperImpl;
import java.lang.reflect.Array;
import org.slf4j.Logger;

public class Util {
    private static final ExceptionWrapper wrapper = new ExceptionWrapperImpl();
    private static final Error FATAL_ERROR = new Error("Fatal error -- Please refer to console output and Terracotta log files for more information");

    public static String enumerateArray(Object array) {
        StringBuffer buf = new StringBuffer();
        if (array != null) {
            if (array.getClass().isArray()) {
                int n = Array.getLength(array);
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append("<<" + Array.get(array, i) + ">>");
                }
            } else {
                buf.append("<").append(array.getClass()).append(" is not an array>");
            }
        } else {
            buf.append("null");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printLogAndRethrowError(Throwable t, Logger logger) {
        if (t == null) {
            throw null;
        }
        try {
            try {
                t.printStackTrace();
            }
            catch (Throwable throwable) {
                logger.error("Exception: ", t);
                throw throwable;
            }
            logger.error("Exception: ", t);
        }
        catch (Throwable err) {
            try {
                err.printStackTrace();
            }
            catch (Throwable err2) {
                // empty catch block
            }
        }
        finally {
            RuntimeException re;
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            try {
                re = new RuntimeException("Unexpected Error " + t.getMessage(), t);
            }
            catch (Throwable err3) {
                try {
                    err3.printStackTrace();
                }
                catch (Throwable err4) {}
                throw FATAL_ERROR;
            }
            throw re;
        }
    }

    public static void selfInterruptIfNeeded(boolean isInterrupted) {
        if (isInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static int hash(Object key, int limit) {
        if (limit == 1) {
            return 0;
        }
        int hashValue = Util.hash(key.hashCode());
        if (hashValue == Integer.MIN_VALUE) {
            --hashValue;
        }
        hashValue = Math.abs(hashValue);
        return hashValue % limit;
    }

    private static int hash(int h) {
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    public static String getFormattedMessage(String msg) {
        return wrapper.wrap(msg);
    }
}

