/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management;

import com.tc.exception.TCRuntimeException;
import com.tc.management.TerracottaMBean;
import com.tc.properties.TCPropertiesImpl;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.StandardMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTerracottaMBean
extends StandardMBean
implements NotificationEmitter,
TerracottaMBean {
    private static final ResourceBundle DEFAULT_BUNDLE = AbstractTerracottaMBean.getBundleForMBean(TerracottaMBean.class, LoggerFactory.getLogger(TerracottaMBean.class));
    private static final boolean ENABLED = TCPropertiesImpl.getProperties().getBoolean("tc.management.mbeans.enabled");
    private final Logger logger;
    private final ResourceBundle beanBundle;
    private final boolean isNotificationBroadcaster;
    private final List<Listener> notificationListeners = new CopyOnWriteArrayList<Listener>();
    private boolean isActive;
    protected static final MBeanNotificationInfo[] EMPTY_NOTIFICATION_INFO = new MBeanNotificationInfo[0];

    protected AbstractTerracottaMBean(Class<?> mBeanInterface, boolean isNotificationBroadcaster) throws NotCompliantMBeanException {
        this(mBeanInterface, isNotificationBroadcaster, ENABLED);
    }

    protected AbstractTerracottaMBean(Class<?> mBeanInterface, boolean isNotificationBroadcaster, boolean isActive) throws NotCompliantMBeanException {
        super(mBeanInterface);
        this.logger = LoggerFactory.getLogger(mBeanInterface);
        this.beanBundle = AbstractTerracottaMBean.getBundleForMBean(mBeanInterface, this.logger);
        this.isNotificationBroadcaster = isNotificationBroadcaster;
        this.isActive = isActive;
    }

    @Override
    public final String getInterfaceClassName() {
        return this.getMBeanInterface().getName();
    }

    public final boolean hasListeners() {
        return !this.notificationListeners.isEmpty();
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object obj) {
        if (!this.isListenerInSameClassLoader(listener)) {
            return;
        }
        this.notificationListeners.add(new Listener(listener, filter, obj));
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.isNotificationBroadcaster()) {
            TCRuntimeException re = new TCRuntimeException("MBean error: this MBean[" + this.getClass().getName() + "] must override getNotificationInfo() since" + " it broadcasts notifications");
            throw re;
        }
        return new MBeanNotificationInfo[0];
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object obj) throws ListenerNotFoundException {
        if (!this.isListenerInSameClassLoader(listener)) {
            return;
        }
        boolean removed = false;
        for (Listener lsnr : this.notificationListeners) {
            if (lsnr.listener != listener || lsnr.filter != filter || lsnr.handback != obj) continue;
            removed = true;
            this.notificationListeners.remove(lsnr);
        }
        if (!removed) {
            throw new ListenerNotFoundException();
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (!this.isListenerInSameClassLoader(listener)) {
            return;
        }
        boolean removed = false;
        for (Listener lsnr : this.notificationListeners) {
            if (lsnr.listener != listener) continue;
            removed = true;
            this.notificationListeners.remove(lsnr);
        }
        if (!removed) {
            throw new ListenerNotFoundException();
        }
    }

    private boolean isListenerInSameClassLoader(NotificationListener listener) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("checking notification listener " + listener + " - CL : " + listener.getClass().getClassLoader());
        }
        ClassLoader currentCl = this.getClass().getClassLoader();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("current CL : " + currentCl);
        }
        try {
            Field[] declaredFields;
            for (Field field : declaredFields = listener.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object subListener = field.get(listener);
                if (subListener == null || !(subListener instanceof NotificationListener)) continue;
                ClassLoader fieldObjectCl = subListener.getClass().getClassLoader();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("checking notification listener field " + subListener + " - CL : " + fieldObjectCl);
                }
                if (fieldObjectCl == currentCl) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Unauthorized classloader of listener field " + subListener + ", NOT authorizing notification listener " + listener);
                }
                return false;
            }
        }
        catch (Exception e) {
            this.logger.warn("Reflection error, NOT authorizing notification listener " + listener, (Throwable)e);
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Authorized notification listener " + listener);
        }
        return true;
    }

    public final void sendNotification(Notification notification) {
        if (this.isEnabled()) {
            for (Listener lsnr : this.notificationListeners) {
                if (lsnr.filter != null && !lsnr.filter.isNotificationEnabled(notification)) continue;
                lsnr.listener.handleNotification(notification, lsnr.handback);
            }
        }
    }

    @Override
    public final boolean isNotificationBroadcaster() {
        return this.isNotificationBroadcaster;
    }

    @Override
    public final void enable() {
        this.setState(true);
    }

    @Override
    public final void disable() {
        this.setState(false);
    }

    private synchronized void setState(boolean isActive) {
        if (this.isActive && !isActive) {
            this.reset();
        }
        boolean previous = this.isActive;
        this.isActive = isActive;
        if (previous != isActive) {
            this.enabledStateChanged();
        }
    }

    protected synchronized void enabledStateChanged() {
    }

    @Override
    public final synchronized boolean isEnabled() {
        return this.isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getDescription(MBeanFeatureInfo featureInfo) {
        String name = featureInfo.getName();
        String bundleDescription = null;
        if (this.beanBundle != null) {
            try {
                bundleDescription = this.beanBundle.getString(name);
            }
            catch (MissingResourceException mre) {
                if (DEFAULT_BUNDLE != null) {
                    try {
                        bundleDescription = DEFAULT_BUNDLE.getString(name);
                    }
                    catch (MissingResourceException defaultMre) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable t) {
                this.logger.warn("Unexpected error while trying to retrieve feature description[" + name + "]", t);
            }
            finally {
                if (bundleDescription == null) {
                    bundleDescription = super.getDescription(featureInfo);
                }
            }
        }
        return bundleDescription;
    }

    private static ResourceBundle getBundleForMBean(Class<?> mBeanInterface, Logger logger) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(mBeanInterface.getName(), Locale.getDefault(), AbstractTerracottaMBean.class.getClassLoader());
        }
        catch (MissingResourceException mre) {
        }
        catch (Throwable t) {
            logger.warn("Unexpected error loading resource bundle for MBean " + mBeanInterface.getName(), t);
        }
        return bundle;
    }

    private static class Listener {
        private final NotificationListener listener;
        private final NotificationFilter filter;
        private final Object handback;

        Listener(NotificationListener listener, NotificationFilter filter, Object obj) {
            this.listener = listener;
            this.filter = filter;
            this.handback = obj;
        }
    }
}

