/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.encoding.dataholders;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.terracotta.runnel.encoding.dataholders.AbstractDataHolder;
import org.terracotta.runnel.utils.WriteBuffer;

public class StringDataHolder
extends AbstractDataHolder {
    private final ByteBuffer encodedString;

    public StringDataHolder(String value, int index) {
        super(index);
        this.encodedString = this.encodeString(value);
    }

    @Override
    protected int valueSize() {
        return this.encodedString.remaining();
    }

    @Override
    protected void encodeValue(WriteBuffer writeBuffer) {
        writeBuffer.putByteBuffer(this.encodedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer encodeString(String object) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(2 * object.length() + 1);
        try {
            char c;
            int i;
            int length = object.length();
            for (i = 0; i < length && (c = object.charAt(i)) != '\u0000' && c <= '\u007f'; ++i) {
                bout.write(c);
            }
            while (i < length) {
                c = object.charAt(i);
                if (c == '\u0000') {
                    bout.write(192);
                    bout.write(128);
                } else if (c < '\u0080') {
                    bout.write(c);
                } else if (c < '\u0800') {
                    bout.write(0xC0 | c >>> 6 & 0x1F);
                    bout.write(0x80 | c & 0x3F);
                } else {
                    bout.write(0xE0 | c >>> 12 & 0x1F);
                    bout.write(0x80 | c >>> 6 & 0x3F);
                    bout.write(0x80 | c & 0x3F);
                }
                ++i;
            }
        }
        finally {
            try {
                bout.close();
            }
            catch (IOException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        return ByteBuffer.wrap(bout.toByteArray());
    }
}

