/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.delivery;

import com.tc.net.protocol.ClientNetworkStackHarness;
import com.tc.net.protocol.NetworkStackHarness;
import com.tc.net.protocol.NetworkStackHarnessFactory;
import com.tc.net.protocol.ServerNetworkStackHarness;
import com.tc.net.protocol.delivery.OOOConnectionWatcher;
import com.tc.net.protocol.delivery.OOOReconnectionTimeout;
import com.tc.net.protocol.delivery.OnceAndOnlyOnceProtocolNetworkLayer;
import com.tc.net.protocol.delivery.OnceAndOnlyOnceProtocolNetworkLayerFactory;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.MessageChannelInternal;
import com.tc.net.protocol.tcm.ServerMessageChannelFactory;
import com.tc.net.protocol.transport.ClientConnectionEstablisher;
import com.tc.net.protocol.transport.ClientMessageTransport;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportFactory;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.properties.ReconnectConfig;

public class OOONetworkStackHarnessFactory
implements NetworkStackHarnessFactory {
    private final OnceAndOnlyOnceProtocolNetworkLayerFactory factory;
    private final ReconnectConfig reconnectConfig;

    public OOONetworkStackHarnessFactory(OnceAndOnlyOnceProtocolNetworkLayerFactory factory, ReconnectConfig reconnectConfig) {
        this.factory = factory;
        this.reconnectConfig = reconnectConfig;
    }

    @Override
    public NetworkStackHarness createClientHarness(MessageTransportFactory transportFactory, ClientMessageChannel channel, MessageTransportListener[] transportListeners) {
        final OnceAndOnlyOnceProtocolNetworkLayer layer = this.factory.createNewClientInstance(this.reconnectConfig);
        final long timeout = this.reconnectConfig != null ? (long)this.reconnectConfig.getReconnectTimeout() : 0L;
        layer.addTransportListener(channel);
        ClientNetworkStackHarness harness = new ClientNetworkStackHarness(transportFactory, channel, true){

            @Override
            protected MessageTransportListener createTransportListener(ClientMessageTransport transport, ClientConnectionEstablisher cce) {
                return new OOOConnectionWatcher(transport, cce, layer, timeout);
            }
        };
        harness.appendIntermediateLayer(layer);
        return harness;
    }

    @Override
    public NetworkStackHarness createServerHarness(ServerMessageChannelFactory channelFactory, MessageTransport transport, MessageTransportListener[] transportListeners) {
        transport.setAllowConnectionReplace(true);
        final OnceAndOnlyOnceProtocolNetworkLayer layer = this.factory.createNewServerInstance(this.reconnectConfig);
        final long timeout = this.reconnectConfig != null ? (long)this.reconnectConfig.getReconnectTimeout() : 0L;
        ServerNetworkStackHarness harness = new ServerNetworkStackHarness(channelFactory, transport){

            @Override
            protected MessageTransportListener createTransportListener(MessageChannelInternal created) {
                layer.addTransportListener(created);
                return new OOOReconnectionTimeout(layer, timeout);
            }
        };
        harness.appendIntermediateLayer(layer);
        return harness;
    }
}

