/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.diagnostic;

import com.terracotta.diagnostic.Diagnostics;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityClientService;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.exception.EntityException;

public class DiagnosticEntityClientService
implements EntityClientService<Diagnostics, Object, EntityMessage, EntityResponse, Properties> {
    @Override
    public boolean handlesEntityType(Class<Diagnostics> type) {
        return type == Diagnostics.class;
    }

    @Override
    public byte[] serializeConfiguration(Object c) {
        return new byte[0];
    }

    @Override
    public Object deserializeConfiguration(byte[] bytes) {
        return new Object();
    }

    @Override
    public Diagnostics create(final EntityClientEndpoint<EntityMessage, EntityResponse> ece, Properties possible) {
        final int timeoutInMillis = possible != null ? Integer.parseInt(possible.getProperty("request.timeout", "2000")) : 2000;
        final String timeoutMessage = possible != null ? possible.getProperty("request.timeoutMessage", "Request Timeout") : "Request Timeout";
        return (Diagnostics)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Diagnostics.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, final Object[] args) throws Throwable {
                try {
                    final String methodName = method.getName();
                    InvokeFuture returnValue = ece.beginInvoke().message(new EntityMessage(){

                        public String toString() {
                            if (methodName.equals("get")) {
                                return "getJMX " + args[0] + " " + args[1];
                            }
                            if (methodName.equals("set")) {
                                return "setJMX " + args[0] + " " + args[1] + " " + args[2];
                            }
                            if (methodName.equals("invoke")) {
                                return "invokeJMX " + args[0] + " " + args[1];
                            }
                            return methodName;
                        }
                    }).invoke();
                    if (!methodName.equals("terminateServer") && !methodName.equals("forceTerminateServer")) {
                        try {
                            return returnValue.getWithTimeout(timeoutInMillis, TimeUnit.MILLISECONDS).toString();
                        }
                        catch (TimeoutException timeout) {
                            return timeoutMessage;
                        }
                    }
                }
                catch (EntityException ee) {
                }
                catch (InterruptedException ie) {
                }
                catch (MessageCodecException code) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    @Override
    public MessageCodec<EntityMessage, EntityResponse> getMessageCodec() {
        final Charset charset = Charset.forName("UTF-8");
        return new MessageCodec<EntityMessage, EntityResponse>(){

            @Override
            public byte[] encodeMessage(EntityMessage m) throws MessageCodecException {
                return m.toString().getBytes(charset);
            }

            @Override
            public EntityMessage decodeMessage(final byte[] bytes) throws MessageCodecException {
                return new EntityMessage(){

                    public String toString() {
                        return new String(bytes, charset);
                    }
                };
            }

            @Override
            public byte[] encodeResponse(EntityResponse r) throws MessageCodecException {
                return r.toString().getBytes(charset);
            }

            @Override
            public EntityResponse decodeResponse(final byte[] bytes) throws MessageCodecException {
                return new EntityResponse(){

                    public String toString() {
                        return new String(bytes, charset);
                    }
                };
            }
        };
    }
}

