/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.handler;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.ConfigurationContext;
import com.tc.object.ClientConfigurationContext;
import com.tc.object.handshakemanager.ClientHandshakeManager;
import com.tc.object.msg.ClientHandshakeAckMessage;
import com.tc.object.msg.ClientHandshakeRefusedMessage;
import com.tc.object.msg.ClientHandshakeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCoordinationHandler
extends AbstractEventHandler<ClientHandshakeResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientCoordinationHandler.class);
    private ClientHandshakeManager clientHandshakeManager;

    @Override
    public void handleEvent(ClientHandshakeResponse context) {
        if (context instanceof ClientHandshakeRefusedMessage) {
            LOGGER.error(((ClientHandshakeRefusedMessage)context).getRefusalsCause());
            LOGGER.info("L1 Exiting...");
            throw new RuntimeException(((ClientHandshakeRefusedMessage)context).getRefusalsCause());
        }
        if (!(context instanceof ClientHandshakeAckMessage)) {
            throw new AssertionError((Object)("unknown event type: " + context.getClass().getName()));
        }
        this.handleClientHandshakeAckMessage((ClientHandshakeAckMessage)context);
    }

    private void handleClientHandshakeAckMessage(ClientHandshakeAckMessage handshakeAck) {
        this.clientHandshakeManager.acknowledgeHandshake(handshakeAck);
    }

    @Override
    public synchronized void initialize(ConfigurationContext context) {
        super.initialize(context);
        ClientConfigurationContext ccContext = (ClientConfigurationContext)context;
        this.clientHandshakeManager = ccContext.getClientHandshakeManager();
    }
}

