/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.object.ObjectID;
import com.tc.util.Assert;
import com.tc.util.ClassUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum LiteralValues {
    INTEGER{

        @Override
        public String getTypeDesc() {
            return "I";
        }

        @Override
        public String getClassNameSlashForPrimitives() {
            return "java/lang/Integer";
        }

        @Override
        public String getMethodNameForPrimitives() {
            return "intValue";
        }

        @Override
        public String getInputMethodDescriptor() {
            return "()I";
        }

        @Override
        public String getInputMethodName() {
            return "readInt";
        }

        @Override
        public String getOutputMethodDescriptor() {
            return "(I)V";
        }

        @Override
        public String getOutputMethodName() {
            return "writeInt";
        }
    }
    ,
    LONG{

        @Override
        public String getTypeDesc() {
            return "J";
        }

        @Override
        public String getClassNameSlashForPrimitives() {
            return "java/lang/Long";
        }

        @Override
        public String getMethodNameForPrimitives() {
            return "longValue";
        }

        @Override
        public String getInputMethodDescriptor() {
            return "()J";
        }

        @Override
        public String getInputMethodName() {
            return "readLong";
        }

        @Override
        public String getOutputMethodDescriptor() {
            return "(J)V";
        }

        @Override
        public String getOutputMethodName() {
            return "writeLong";
        }
    }
    ,
    CHARACTER{

        @Override
        public String getTypeDesc() {
            return "C";
        }

        @Override
        public String getClassNameSlashForPrimitives() {
            return "java/lang/Character";
        }

        @Override
        public String getMethodNameForPrimitives() {
            return "charValue";
        }

        @Override
        public String getInputMethodDescriptor() {
            return "()C";
        }

        @Override
        public String getInputMethodName() {
            return "readChar";
        }

        @Override
        public String getOutputMethodDescriptor() {
            return "(I)V";
        }

        @Override
        public String getOutputMethodName() {
            return "writeChar";
        }
    }
    ,
    FLOAT{

        @Override
        public String getTypeDesc() {
            return "F";
        }

        @Override
        public String getClassNameSlashForPrimitives() {
            return "java/lang/Float";
        }

        @Override
        public String getMethodNameForPrimitives() {
            return "floatValue";
        }

        @Override
        public String getInputMethodDescriptor() {
            return "()F";
        }

        @Override
        public String getInputMethodName() {
            return "readFloat";
        }

        @Override
        public String getOutputMethodDescriptor() {
            return "(F)V";
        }

        @Override
        public String getOutputMethodName() {
            return "writeFloat";
        }
    }
    ,
    DOUBLE{

        @Override
        public String getTypeDesc() {
            return "D";
        }

        @Override
        public String getClassNameSlashForPrimitives() {
            return "java/lang/Double";
        }

        @Override
        public String getMethodNameForPrimitives() {
            return "doubleValue";
        }

        @Override
        public String getInputMethodDescriptor() {
            return "()D";
        }

        @Override
        public String getInputMethodName() {
            return "readDouble";
        }

        @Override
        public String getOutputMethodDescriptor() {
            return "(D)V";
        }

        @Override
        public String getOutputMethodName() {
            return "writeDouble";
        }
    }
    ,
    BYTE{

        @Override
        public String getTypeDesc() {
            return "B";
        }

        @Override
        public String getClassNameSlashForPrimitives() {
            return "java/lang/Byte";
        }

        @Override
        public String getMethodNameForPrimitives() {
            return "byteValue";
        }

        @Override
        public String getInputMethodDescriptor() {
            return "()B";
        }

        @Override
        public String getInputMethodName() {
            return "readByte";
        }

        @Override
        public String getOutputMethodDescriptor() {
            return "(I)V";
        }

        @Override
        public String getOutputMethodName() {
            return "writeByte";
        }
    }
    ,
    BOOLEAN{

        @Override
        public String getTypeDesc() {
            return "Z";
        }

        @Override
        public String getClassNameSlashForPrimitives() {
            return "java/lang/Boolean";
        }

        @Override
        public String getMethodNameForPrimitives() {
            return "booleanValue";
        }

        @Override
        public String getInputMethodDescriptor() {
            return "()Z";
        }

        @Override
        public String getInputMethodName() {
            return "readBoolean";
        }

        @Override
        public String getOutputMethodDescriptor() {
            return "(Z)V";
        }

        @Override
        public String getOutputMethodName() {
            return "writeBoolean";
        }
    }
    ,
    SHORT{

        @Override
        public String getTypeDesc() {
            return "S";
        }

        @Override
        public String getClassNameSlashForPrimitives() {
            return "java/lang/Short";
        }

        @Override
        public String getMethodNameForPrimitives() {
            return "shortValue";
        }

        @Override
        public String getInputMethodDescriptor() {
            return "()S";
        }

        @Override
        public String getInputMethodName() {
            return "readShort";
        }

        @Override
        public String getOutputMethodDescriptor() {
            return "(I)V";
        }

        @Override
        public String getOutputMethodName() {
            return "writeShort";
        }
    }
    ,
    STRING,
    ARRAY{

        @Override
        public int calculateDsoHashCodeForLiteral(Object value) {
            throw new UnsupportedOperationException("Cannot calculate hashCode for " + this.name());
        }
    }
    ,
    OBJECT{

        @Override
        public int calculateDsoHashCodeForLiteral(Object value) {
            throw new UnsupportedOperationException("Cannot calculate hashCode for " + this.name());
        }
    }
    ,
    OBJECT_ID,
    STRING_BYTES,
    JAVA_LANG_CLASS{

        @Override
        public int calculateDsoHashCodeForLiteral(Object value) {
            return ((Class)value).getCanonicalName().hashCode();
        }
    }
    ,
    JAVA_LANG_CLASS_HOLDER,
    ENUM{

        @Override
        public int calculateDsoHashCodeForLiteral(Object value) {
            Enum e = (Enum)value;
            int hash = 17;
            hash = 31 * hash + e.name().hashCode();
            hash = 31 * hash + e.getDeclaringClass().getCanonicalName().hashCode();
            return hash;
        }
    }
    ,
    ENUM_HOLDER,
    STRING_BYTES_COMPRESSED;

    public static final String ENUM_CLASS_DOTS = "java.lang.Enum";
    private static final Map<String, LiteralValues> literalsMap;

    public String getInputMethodName() {
        return "readObject";
    }

    public String getInputMethodDescriptor() {
        return "()Ljava/lang/Object;";
    }

    public String getOutputMethodName() {
        return "writeObject";
    }

    public String getOutputMethodDescriptor() {
        return "(Ljava/lang/Object;)V";
    }

    public String getTypeDesc() {
        return "Ljava/lang/Object;";
    }

    public String getClassNameSlashForPrimitives() {
        return "java/lang/Object";
    }

    public String getMethodNameForPrimitives() {
        throw new AssertionError((Object)("Only Primitive types allowed. Invalid type: " + this.toString()));
    }

    public int calculateDsoHashCodeForLiteral(Object value) {
        if (!LiteralValues.isLiteralInstance(value)) {
            throw new UnsupportedOperationException("Cannot calculate hashCode for non-literals");
        }
        return value.hashCode();
    }

    private static void addMapping(Map<String, LiteralValues> map, String className, LiteralValues type) {
        LiteralValues prev = map.put(className, type);
        Assert.assertNull(className, (Object)prev);
    }

    public static LiteralValues valueFor(Object pojo) {
        Class<?> clazz = pojo.getClass();
        LiteralValues i = LiteralValues.valueForClassName(clazz.getName());
        if (i == OBJECT && ClassUtils.isDsoEnum(pojo.getClass())) {
            return ENUM;
        }
        return i;
    }

    public static LiteralValues valueForClassName(String className) {
        if (className != null && className.startsWith("[")) {
            return ARRAY;
        }
        LiteralValues literalValueType = literalsMap.get(className);
        if (literalValueType == null) {
            return OBJECT;
        }
        return literalValueType;
    }

    public static boolean isLiteral(String className) {
        LiteralValues i = LiteralValues.valueForClassName(className);
        return i != OBJECT;
    }

    public static boolean isLiteralInstance(Object obj) {
        if (obj == null) {
            return false;
        }
        LiteralValues i = LiteralValues.valueFor(obj);
        return i != OBJECT;
    }

    static {
        HashMap<String, LiteralValues> tmp = new HashMap<String, LiteralValues>();
        LiteralValues.addMapping(tmp, Integer.class.getName(), INTEGER);
        LiteralValues.addMapping(tmp, Integer.TYPE.getName(), INTEGER);
        LiteralValues.addMapping(tmp, Long.class.getName(), LONG);
        LiteralValues.addMapping(tmp, Long.TYPE.getName(), LONG);
        LiteralValues.addMapping(tmp, Character.class.getName(), CHARACTER);
        LiteralValues.addMapping(tmp, Character.TYPE.getName(), CHARACTER);
        LiteralValues.addMapping(tmp, Float.class.getName(), FLOAT);
        LiteralValues.addMapping(tmp, Float.TYPE.getName(), FLOAT);
        LiteralValues.addMapping(tmp, Double.class.getName(), DOUBLE);
        LiteralValues.addMapping(tmp, Double.TYPE.getName(), DOUBLE);
        LiteralValues.addMapping(tmp, Byte.class.getName(), BYTE);
        LiteralValues.addMapping(tmp, Byte.TYPE.getName(), BYTE);
        LiteralValues.addMapping(tmp, String.class.getName(), STRING);
        LiteralValues.addMapping(tmp, "com.tc.object.dna.impl.UTF8ByteDataHolder", STRING_BYTES);
        LiteralValues.addMapping(tmp, "com.tc.object.dna.impl.UTF8ByteCompressedDataHolder", STRING_BYTES_COMPRESSED);
        LiteralValues.addMapping(tmp, Short.class.getName(), SHORT);
        LiteralValues.addMapping(tmp, Short.TYPE.getName(), SHORT);
        LiteralValues.addMapping(tmp, Boolean.class.getName(), BOOLEAN);
        LiteralValues.addMapping(tmp, Boolean.TYPE.getName(), BOOLEAN);
        LiteralValues.addMapping(tmp, Class.class.getName(), JAVA_LANG_CLASS);
        LiteralValues.addMapping(tmp, "com.tc.object.dna.impl.ClassInstance", JAVA_LANG_CLASS_HOLDER);
        LiteralValues.addMapping(tmp, ObjectID.class.getName(), OBJECT_ID);
        LiteralValues.addMapping(tmp, ENUM_CLASS_DOTS, ENUM);
        LiteralValues.addMapping(tmp, "com.tc.object.dna.impl.EnumInstance", ENUM_HOLDER);
        literalsMap = Collections.unmodifiableMap(tmp);
    }
}

