/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.object.ObjectID;
import com.tc.util.BitSetObjectIDSet;
import com.tc.util.ObjectIDSet;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class StripedObjectIDSet
implements SortedSet<ObjectID> {
    private static final int DEFAULT_CONCURRENCY = 64;
    private final ObjectIDSet[] objectIdSets;
    private final ReentrantReadWriteLock[] locks;
    private final int concurrency;

    public StripedObjectIDSet() {
        this(64);
    }

    public StripedObjectIDSet(int concurrency) {
        this.concurrency = concurrency;
        this.objectIdSets = new ObjectIDSet[this.concurrency];
        this.locks = new ReentrantReadWriteLock[this.concurrency];
        for (int i = 0; i < this.concurrency; ++i) {
            this.objectIdSets[i] = new BitSetObjectIDSet();
            this.locks[i] = new ReentrantReadWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(ObjectID o) {
        int index = this.getIndex(o);
        ReentrantReadWriteLock lock = this.locks[index];
        ObjectIDSet oidSet = this.objectIdSets[index];
        lock.writeLock().lock();
        try {
            boolean bl = oidSet.add(o);
            return bl;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends ObjectID> collection) {
        boolean success = true;
        for (ObjectID objectID : collection) {
            if (this.add(objectID)) continue;
            success = false;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        for (int index = 0; index < this.concurrency; ++index) {
            ReentrantReadWriteLock.WriteLock l = this.locks[index].writeLock();
            l.lock();
            try {
                this.objectIdSets[index].clear();
                continue;
            }
            finally {
                l.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        if (!(o instanceof ObjectID)) {
            return false;
        }
        int index = this.getIndex((ObjectID)o);
        ReentrantReadWriteLock lock = this.locks[index];
        ObjectIDSet oidSet = this.objectIdSets[index];
        lock.readLock().lock();
        try {
            boolean bl = oidSet.contains(o);
            return bl;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object oid : collection) {
            if (this.contains(oid)) continue;
            return false;
        }
        return true;
    }

    private void lockAll() {
        for (ReentrantReadWriteLock lock : this.locks) {
            lock.readLock().lock();
        }
    }

    private void unlockAll() {
        for (ReentrantReadWriteLock lock : this.locks) {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.lockAll();
        try {
            for (int index = 0; index < this.concurrency; ++index) {
                if (this.objectIdSets[index].isEmpty()) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.unlockAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        if (!(o instanceof ObjectID)) {
            return false;
        }
        int index = this.getIndex((ObjectID)o);
        ReentrantReadWriteLock lock = this.locks[index];
        ObjectIDSet oidSet = this.objectIdSets[index];
        lock.writeLock().lock();
        try {
            boolean bl = oidSet.remove(o);
            return bl;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean success = true;
        for (Object oid : collection) {
            if (this.remove(oid)) continue;
            success = false;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean success = false;
        for (int index = 0; index < this.concurrency; ++index) {
            ReentrantReadWriteLock.WriteLock lock = this.locks[index].writeLock();
            lock.lock();
            try {
                if (this.objectIdSets[index].retainAll(collection)) continue;
                success = true;
                continue;
            }
            finally {
                lock.unlock();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int size = 0;
        this.lockAll();
        try {
            for (int index = 0; index < this.concurrency; ++index) {
                size += this.objectIdSets[index].size();
            }
        }
        finally {
            this.unlockAll();
        }
        return size;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        int index;
        BitSetObjectIDSet sortedSet = new BitSetObjectIDSet();
        for (index = 0; index < this.concurrency; ++index) {
            this.locks[index].readLock().lock();
        }
        try {
            for (index = 0; index < this.concurrency; ++index) {
                sortedSet.addAll(this.objectIdSets[index]);
            }
        }
        finally {
            for (index = 0; index < this.concurrency; ++index) {
                this.locks[index].readLock().unlock();
            }
        }
        int size = sortedSet.size();
        if (a.length < size) {
            a = StripedObjectIDSet.makeArray(a, size);
        }
        Iterator it = sortedSet.iterator();
        T[] result = a;
        for (int i = 0; i < size; ++i) {
            result[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    private static <T> T[] makeArray(T[] a, int size) {
        return (Object[])Array.newInstance(a.getClass().getComponentType(), size);
    }

    private int getIndex(ObjectID oid) {
        long maskedOid = Math.abs(BitSetObjectIDSet.calculateStart(oid.toLong()) / 64L);
        return (int)Math.abs(maskedOid % (long)this.concurrency);
    }

    @Override
    public ObjectID first() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectID last() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<ObjectID> headSet(ObjectID toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<ObjectID> subSet(ObjectID fromElement, ObjectID toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<ObjectID> tailSet(ObjectID fromElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<ObjectID> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<? super ObjectID> comparator() {
        return null;
    }

    ObjectIDSet[] getObjectIDSets() {
        return this.objectIdSets;
    }
}

