/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.util.StringUtil;
import com.tc.util.TCAssertionError;
import java.util.Arrays;
import java.util.Collection;

public class Assert {
    public static TCAssertionError failure(Object message, Throwable t) {
        return new TCAssertionError(StringUtil.safeToString(message), t);
    }

    public static TCAssertionError failure(Object message) {
        return new TCAssertionError(StringUtil.safeToString(message));
    }

    public static void eval(boolean expr) {
        if (!expr) {
            throw Assert.failure("Assertion failed");
        }
    }

    public static void eval(Object message, boolean expr) {
        if (!expr) {
            throw Assert.failure("Assertion failed: " + StringUtil.safeToString(message));
        }
    }

    public static void assertTrue(boolean expr) {
        Assert.eval(expr);
    }

    public static void assertTrue(Object message, boolean expr) {
        Assert.eval(message, expr);
    }

    public static void assertFalse(boolean expr) {
        Assert.eval(!expr);
    }

    public static void assertFalse(Object message, boolean expr) {
        Assert.eval(message, !expr);
    }

    public static void assertNull(Object o) {
        Assert.assertNull("object", o);
    }

    public static void assertNull(Object what, Object o) {
        if (o != null) {
            throw Assert.failure(StringUtil.safeToString(what) + " was not null");
        }
    }

    public static void assertNotNull(Object what, Object o) {
        if (o == null) {
            throw new NullPointerException(StringUtil.safeToString(what) + " is null");
        }
    }

    public static void assertNotNull(Object o) {
        Assert.assertNotNull("object", o);
    }

    public static void assertNoNullElements(Object[] array) {
        Assert.assertNotNull(array);
        for (int i = 0; i < array.length; ++i) {
            Assert.assertNotNull("item " + i, array[i]);
        }
    }

    public static void assertNoBlankElements(String[] array) {
        Assert.assertNotNull(array);
        for (String s : array) {
            Assert.assertNotBlank(s);
        }
    }

    public static void assertNotEmpty(Object what, String s) {
        Assert.assertNotNull(what, s);
        if (s.length() == 0) {
            throw new IllegalArgumentException(StringUtil.safeToString(what) + " is empty");
        }
    }

    public static void assertNotEmpty(String s) {
        Assert.assertNotEmpty("string", s);
    }

    public static void assertNotBlank(Object what, String s) {
        Assert.assertNotEmpty(what, s);
        if (s.trim().length() == 0) {
            throw new IllegalArgumentException(StringUtil.safeToString(what) + " is blank");
        }
    }

    public static void assertNotBlank(String s) {
        Assert.assertNotBlank("string", s);
    }

    public static void assertSame(Object lhs, Object rhs) {
        if (lhs == null) {
            Assert.eval("leftHandSide == null, but rightHandSide != null", rhs == null);
        } else {
            Assert.eval("leftHandSide != null, but rightHandSide == null", rhs != null);
            Assert.eval("leftHandSide != rightHandSide", lhs == rhs);
        }
    }

    public static void assertEquals(int expected, int actual) {
        if (expected != actual) {
            throw new TCAssertionError("Expected <" + expected + "> but got <" + actual + ">");
        }
    }

    public static void assertEquals(long expected, long actual) {
        if (expected != actual) {
            throw new TCAssertionError("Expected <" + expected + "> but got <" + actual + ">");
        }
    }

    public static void assertEquals(Object msg, int expected, int actual) {
        if (expected != actual) {
            throw new TCAssertionError(msg + ": Expected <" + expected + "> but got <" + actual + ">");
        }
    }

    public static void assertEquals(double expected, double actual) {
        if (expected != actual) {
            throw new TCAssertionError("Expected <" + expected + "> but got <" + actual + ">");
        }
    }

    public static void assertEquals(double expected, double actual, double epsilon) {
        if (Math.abs(actual - expected) > Math.abs(epsilon)) {
            throw new TCAssertionError("Expected <" + expected + "> but got <" + actual + ">");
        }
    }

    public static void assertEquals(boolean expected, boolean actual) {
        if (expected != actual) {
            throw new TCAssertionError("Expected <" + expected + "> but got <" + actual + ">");
        }
    }

    public static void assertEquals(byte[] expected, byte[] actual) {
        boolean expr;
        boolean bl = expected == null ? actual == null : (expr = Arrays.equals(expected, actual));
        if (!expr) {
            throw new TCAssertionError("Got differing byte[]s");
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(Object msg, Object expected, Object actual) {
        boolean expr;
        boolean bl = expected == null ? actual == null : (expr = expected.equals(actual));
        if (!expr) {
            throw new TCAssertionError((msg != null ? msg + ": " : "") + "Expected <" + expected + "> but got <" + actual + ">");
        }
    }

    public static <T> void assertConsistentCollection(Collection<T> collection, Class<T> elementClass, boolean allowNullElements) {
        Assert.assertNotNull("Collection", collection);
        Assert.assertNotNull("Element class", elementClass);
        for (T element : collection) {
            if (!allowNullElements) {
                Assert.assertNotNull(element);
            }
            if (element == null) continue;
            Assert.eval("Element '" + element + "' is not an instance of '" + elementClass.getName() + "'", elementClass.isInstance(element));
        }
    }

    public static void assertContainsElement(Object[] objectArray, Object requiredElement) {
        Assert.assertNotNull(objectArray);
        for (Object element : objectArray) {
            if (element != requiredElement) continue;
            return;
        }
        throw Assert.failure("Element<" + requiredElement + "> not found in array " + StringUtil.toString(objectArray, ",", "<", ">"));
    }

    public static void assertDoesNotContainsElement(Object[] objectArray, Object element) {
        Assert.assertNotNull(objectArray);
        for (Object o : objectArray) {
            if (o != element) continue;
            Assert.failure("Element<" + element + "> was found in array " + StringUtil.toString(objectArray, ",", "<", ">"));
        }
    }

    public static void fail() {
        throw Assert.failure("generic failure");
    }

    public static void fail(String message) {
        throw Assert.failure(message);
    }
}

