/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.io.TCDataInput;
import com.tc.io.TCDataOutput;
import com.tc.net.ClientID;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.util.ProductID;
import java.io.IOException;

public class ConnectionID {
    private static final char DOT_PLACEHOLDER = '+';
    private static final char DOT = '.';
    private final long channelID;
    private final String serverID;
    private final String jvmID;
    private final Exception initEx;
    private final String username;
    private final ProductID productId;
    private volatile char[] password;
    private static final String NULL_SERVER_ID = "ffffffffffffffffffffffffffffffff";
    public static final String NULL_JVM_ID = "ffffffffffffffffffffffffffffffffffffffffffffffff";
    private static final ProductID DEFAULT_PRODUCT_ID = ProductID.PERMANENT;
    public static final ConnectionID NULL_ID = new ConnectionID("ffffffffffffffffffffffffffffffffffffffffffffffff", ChannelID.NULL_ID.toLong(), "ffffffffffffffffffffffffffffffff");
    private static final char SEP = '.';

    public ConnectionID(String jvmID, long channelID, String serverID) {
        this(jvmID, channelID, serverID, null, null, null);
    }

    public ConnectionID(String jvmID, long channelID, String serverID, String username, String password) {
        this(jvmID, channelID, serverID, username, password == null ? null : password.toCharArray(), null);
    }

    public ConnectionID(String jvmID, long channelID, String serverID, String username, char[] password, ProductID productId) {
        this.jvmID = jvmID;
        this.channelID = channelID;
        this.serverID = serverID;
        this.initEx = jvmID.equals(NULL_JVM_ID) ? new Exception("Created (" + this.getID() + ") by:-----------------------------------------------------------") : null;
        this.username = username;
        this.password = password;
        this.productId = productId == null ? DEFAULT_PRODUCT_ID : productId;
    }

    public void authenticated() {
        this.password = null;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public ConnectionID(String jvmID, long channelID, String username, char[] password, ProductID productId) {
        this(jvmID, channelID, NULL_SERVER_ID, username, password, productId);
    }

    public ConnectionID(String jvmID, long channelID) {
        this(jvmID, channelID, NULL_SERVER_ID);
    }

    public String toString() {
        return "ConnectionID" + (this.isSecured() ? ".secured(" : "(") + this.getID() + ")[" + "]";
    }

    public boolean isNull() {
        return NULL_ID.equals(this);
    }

    public boolean isValid() {
        return this.channelID >= 0L;
    }

    public boolean isNewConnection() {
        return this.serverID.equals(NULL_SERVER_ID);
    }

    public String getServerID() {
        return this.serverID;
    }

    public int hashCode() {
        int hc = 17;
        hc = 37 * hc + (int)(this.channelID ^ this.channelID >>> 32);
        if (this.serverID != null) {
            hc = 37 * hc + this.serverID.hashCode();
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionID) {
            ConnectionID other = (ConnectionID)obj;
            return this.channelID == other.channelID && this.serverID.equals(other.serverID);
        }
        return false;
    }

    public long getChannelID() {
        return this.channelID;
    }

    public String getJvmID() {
        if (this.jvmID.equals(NULL_JVM_ID)) {
            throw new IllegalStateException("Attempt to get jvmID from pseudo-ConnectionID that was not initialized with one.", this.initEx);
        }
        return this.jvmID;
    }

    public boolean isJvmIDNull() {
        return this.jvmID.equals(NULL_JVM_ID);
    }

    public String getID() {
        return this.getID(false);
    }

    public String getID(boolean withCredentials) {
        StringBuilder sb = new StringBuilder(withCredentials ? 128 : 64);
        sb.append(this.channelID).append('.').append(this.serverID).append('.').append(this.jvmID).append('.').append((Object)this.productId);
        if (withCredentials) {
            sb.append('.');
            if (this.username != null) {
                sb.append(this.username.replace('.', '+'));
            }
            sb.append('.');
            if (this.password != null) {
                sb.append(this.password);
            }
        }
        return sb.toString();
    }

    public void writeTo(TCDataOutput out) {
        out.writeLong(this.channelID);
        out.writeString(this.serverID);
        out.writeString(this.jvmID);
        out.writeString(this.productId.name());
        out.writeBoolean(this.username != null);
        if (this.username != null) {
            out.writeString(this.username);
        }
        out.writeBoolean(this.password != null);
        if (this.password != null) {
            out.writeString(String.valueOf(this.password));
        }
    }

    public static ConnectionID readFrom(TCDataInput in) throws IOException {
        long channelID = in.readLong();
        String serverID = in.readString();
        String jvmID = in.readString();
        ProductID productId = ProductID.valueOf(in.readString());
        String username = null;
        char[] password = null;
        if (in.readBoolean()) {
            username = in.readString();
        }
        if (in.readBoolean()) {
            password = in.readString().toCharArray();
        }
        return new ConnectionID(jvmID, channelID, serverID, username, password, productId);
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public boolean isSecured() {
        return this.username != null;
    }

    public ProductID getProductId() {
        return this.productId;
    }

    public ClientID getClientID() {
        return new ClientID(this.channelID);
    }

    public ConnectionID changeProductId(ProductID product) {
        return new ConnectionID(this.jvmID, this.channelID, this.serverID, this.username, this.password, product);
    }
}

