/*
 * Decompiled with CFR 0.152.
 */
package com.tc.cluster;

import com.tc.async.api.Sink;
import com.tc.async.api.Stage;
import com.tc.cluster.ClusterEvent;
import com.tc.cluster.ClusterEventImpl;
import com.tc.cluster.ClusterListener;
import com.tc.cluster.ClusterTopology;
import com.tc.cluster.ClusterTopologyImpl;
import com.tc.exception.TCNotRunningException;
import com.tc.net.ClientID;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Util;
import com.tcclient.cluster.ClusterInternal;
import com.tcclient.cluster.ClusterInternalEventsContext;
import com.tcclient.cluster.ClusterNodeStatus;
import com.tcclient.cluster.Node;
import com.tcclient.cluster.NodeInternal;
import com.tcclient.cluster.OutOfBandClusterListener;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterImpl
implements ClusterInternal {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterImpl.class);
    private volatile ClientID currentClientID;
    private volatile NodeInternal currentNode;
    private final ClusterTopologyImpl topology = new ClusterTopologyImpl();
    private final CopyOnWriteArrayList<ClusterListener> listeners = new CopyOnWriteArrayList();
    private final Object nodeJoinsClusterSync = new Object();
    private final ReentrantReadWriteLock stateLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock stateReadLock = this.stateLock.readLock();
    private final ReentrantReadWriteLock.WriteLock stateWriteLock = this.stateLock.writeLock();
    private final ClusterNodeStatus nodeStatus = new ClusterNodeStatus();
    private final FiredEventsStatus firedEventsStatus = new FiredEventsStatus();
    private final OutOfBandNotifier outOfBandNotifier = new OutOfBandNotifier();
    private Sink<ClusterInternalEventsContext> eventsProcessorSink;

    @Override
    public void init(Stage<ClusterInternalEventsContext> clusterEventsStage) {
        this.eventsProcessorSink = clusterEventsStage.getSink();
        this.outOfBandNotifier.start();
    }

    @Override
    public void shutdown() {
        this.outOfBandNotifier.shutdown();
    }

    @Override
    public void addClusterListener(ClusterListener listener) {
        boolean added = this.listeners.addIfAbsent(listener);
        if (added) {
            ClusterEventImpl event = new ClusterEventImpl(this.currentNode);
            ClusterNodeStatus.ClusterNodeStateType state = this.nodeStatus.getState();
            if (state.isNodeLeft()) {
                this.fireEvent(ClusterInternal.ClusterEventType.NODE_LEFT, event, listener);
            } else {
                if (state.isNodeJoined()) {
                    this.fireEvent(ClusterInternal.ClusterEventType.NODE_JOIN, event, listener);
                }
                if (state.areOperationsEnabled()) {
                    this.fireEvent(ClusterInternal.ClusterEventType.OPERATIONS_ENABLED, event, listener);
                }
            }
        }
    }

    @Override
    public void removeClusterListener(ClusterListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getCurrentNode() {
        this.stateReadLock.lock();
        try {
            NodeInternal nodeInternal = this.currentNode;
            return nodeInternal;
        }
        finally {
            this.stateReadLock.unlock();
        }
    }

    @Override
    public ClusterTopology getClusterTopology() {
        return this.topology;
    }

    @Override
    public boolean isNodeJoined() {
        return this.nodeStatus.getState().isNodeJoined();
    }

    @Override
    public boolean areOperationsEnabled() {
        return this.nodeStatus.getState().areOperationsEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node waitUntilNodeJoinsCluster() {
        boolean interrupted = false;
        try {
            Object object = this.nodeJoinsClusterSync;
            synchronized (object) {
                while (this.currentNode == null) {
                    try {
                        this.nodeJoinsClusterSync.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return this.currentNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaiters() {
        Object object = this.nodeJoinsClusterSync;
        synchronized (object) {
            this.nodeJoinsClusterSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireThisNodeJoined(ClientID nodeId, ClientID[] clusterMembers) {
        ClientID newNodeId = nodeId;
        this.stateWriteLock.lock();
        boolean fireThisNodeJoined = false;
        try {
            if (this.currentNode == null) {
                fireThisNodeJoined = true;
            }
            this.currentClientID = newNodeId;
            this.currentNode = this.topology.registerThisNode(nodeId);
            for (ClientID otherNodeId : clusterMembers) {
                if (this.currentClientID.equals(otherNodeId)) continue;
                this.topology.registerNode(otherNodeId);
            }
            this.nodeStatus.operationsEnabled();
            LOGGER.info("NODE_JOINED " + this.currentClientID);
        }
        finally {
            this.stateWriteLock.unlock();
            if (this.currentNode != null) {
                this.notifyWaiters();
            }
            ClusterEventImpl currentThisNodeEvent = new ClusterEventImpl(this.currentNode);
            if (fireThisNodeJoined) {
                this.fireEventToAllListeners(ClusterInternal.ClusterEventType.NODE_JOIN, currentThisNodeEvent);
            }
            this.fireEventToAllListeners(ClusterInternal.ClusterEventType.OPERATIONS_ENABLED, currentThisNodeEvent);
        }
    }

    @Override
    public void cleanup() {
        this.topology.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireThisNodeLeft() {
        boolean fireOperationsDisabled = false;
        this.stateWriteLock.lock();
        try {
            if (!this.nodeStatus.getState().isNodeJoined()) {
                LOGGER.info("ignoring NODE_LEFT " + this.currentClientID + " because nodeStatus " + (Object)((Object)this.nodeStatus.getState()));
                return;
            }
            if (this.nodeStatus.getState().areOperationsEnabled()) {
                fireOperationsDisabled = true;
            }
            this.nodeStatus.nodeLeft();
            LOGGER.info("NODE_LEFT " + this.currentClientID + " nodeStatus " + this.nodeStatus);
        }
        finally {
            this.stateWriteLock.unlock();
        }
        if (fireOperationsDisabled) {
            this.fireOperationsDisabledNoCheck();
        } else {
            this.firedEventsStatus.waitUntilOperationsDisabledFired();
        }
        this.fireNodeLeft(new ClientID(this.currentNode.getChannelId()));
    }

    @Override
    public void fireNodeJoined(ClientID nodeId) {
        if (this.topology.containsNode(nodeId)) {
            return;
        }
        ClusterEventImpl event = new ClusterEventImpl(this.topology.getAndRegisterNode(nodeId));
        this.fireEventToAllListeners(ClusterInternal.ClusterEventType.NODE_JOIN, event);
    }

    private void fireEventToAllListeners(ClusterInternal.ClusterEventType eventType, ClusterEvent event) {
        LOGGER.debug("event fired |" + (Object)((Object)eventType) + "|" + event.getNode());
        for (ClusterListener l : this.listeners) {
            this.fireEvent(eventType, event, l);
        }
    }

    @Override
    public void fireNodeLeft(ClientID nodeId) {
        NodeInternal node = this.topology.getAndRemoveNode(nodeId);
        if (node == null) {
            return;
        }
        ClusterEventImpl event = new ClusterEventImpl(node);
        this.fireEventToAllListeners(ClusterInternal.ClusterEventType.NODE_LEFT, event);
    }

    @Override
    public void fireNodeError() {
        ClusterEventImpl event = new ClusterEventImpl(this.currentNode);
        this.fireEventToAllListeners(ClusterInternal.ClusterEventType.NODE_ERROR, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireOperationsEnabled() {
        if (this.currentNode != null) {
            this.stateWriteLock.lock();
            try {
                if (this.nodeStatus.getState().areOperationsEnabled()) {
                    LOGGER.info("ignoring OPERATIONS_ENABLED " + this.currentClientID + " because nodeStatus " + (Object)((Object)this.nodeStatus.getState()));
                    return;
                }
                this.nodeStatus.operationsEnabled();
            }
            finally {
                this.stateWriteLock.unlock();
            }
            ClusterEventImpl event = new ClusterEventImpl(this.currentNode);
            this.fireEventToAllListeners(ClusterInternal.ClusterEventType.OPERATIONS_ENABLED, event);
            this.firedEventsStatus.operationsEnabledFired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireOperationsDisabled() {
        this.stateWriteLock.lock();
        try {
            if (!this.nodeStatus.getState().areOperationsEnabled()) {
                LOGGER.info("ignoring OPERATIONS_DISABLED " + this.currentClientID + " because nodeStatus " + (Object)((Object)this.nodeStatus.getState()));
                return;
            }
            this.nodeStatus.operationsDisabled();
        }
        finally {
            this.stateWriteLock.unlock();
        }
        this.fireOperationsDisabledNoCheck();
    }

    private void fireOperationsDisabledNoCheck() {
        ClusterEventImpl event = new ClusterEventImpl(this.currentNode);
        this.fireEventToAllListeners(ClusterInternal.ClusterEventType.OPERATIONS_DISABLED, event);
        this.firedEventsStatus.operationsDisabledFired();
    }

    private void fireEvent(final ClusterInternal.ClusterEventType eventType, final ClusterEvent event, final ClusterListener listener) {
        boolean useOOB = this.useOOBNotification(eventType, event, listener);
        if (useOOB) {
            this.outOfBandNotifier.submit(new Runnable(){

                @Override
                public void run() {
                    ClusterImpl.this.notifyClusterListener(eventType, event, listener);
                }
            });
        } else {
            this.eventsProcessorSink.addSingleThreaded(new ClusterInternalEventsContext(eventType, event, listener));
        }
    }

    private boolean useOOBNotification(ClusterInternal.ClusterEventType eventType, ClusterEvent event, ClusterListener listener) {
        if (listener instanceof OutOfBandClusterListener) {
            return ((OutOfBandClusterListener)listener).useOutOfBandNotification(eventType, event);
        }
        return false;
    }

    @Override
    public void notifyClusterListener(ClusterInternal.ClusterEventType eventType, ClusterEvent event, ClusterListener listener) {
        try {
            switch (eventType) {
                case NODE_JOIN: {
                    listener.nodeJoined(event);
                    return;
                }
                case NODE_LEFT: {
                    listener.nodeLeft(event);
                    return;
                }
                case OPERATIONS_ENABLED: {
                    listener.operationsEnabled(event);
                    return;
                }
                case OPERATIONS_DISABLED: {
                    listener.operationsDisabled(event);
                    return;
                }
                case NODE_REJOINED: {
                    listener.nodeRejoined(event);
                    return;
                }
                case NODE_ERROR: {
                    listener.nodeError(event);
                    return;
                }
            }
            throw new AssertionError((Object)("Unhandled event type: " + (Object)((Object)eventType)));
        }
        catch (TCNotRunningException tcnre) {
            LOGGER.error("Ignoring TCNotRunningException when notifying " + event + " : " + (Object)((Object)eventType));
        }
        catch (Throwable t) {
            LOGGER.error("Problem firing the cluster event : " + (Object)((Object)eventType) + " - " + event, t);
        }
    }

    private static class OutOfBandNotifier {
        private static final String TASK_THREAD_PREFIX = "Out of band notifier";
        private static final long TASK_RUN_TIME_MILLIS = TCPropertiesImpl.getProperties().getLong("l1.clusterevents.outofbandnotifier.jointime.millis", 100L);
        private final LinkedBlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue();
        private volatile long count = 0L;
        private volatile boolean shutdown;

        private OutOfBandNotifier() {
        }

        private void submit(Runnable taskToExecute) {
            this.taskQueue.add(taskToExecute);
        }

        private void start() {
            Thread outOfBandNotifierThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!OutOfBandNotifier.this.shutdown) {
                        Runnable taskToExecute;
                        try {
                            taskToExecute = (Runnable)OutOfBandNotifier.this.taskQueue.take();
                        }
                        catch (InterruptedException e) {
                            continue;
                        }
                        Thread oobTask = new Thread(taskToExecute, "Out of band notifier - " + OutOfBandNotifier.this.count++);
                        oobTask.setDaemon(true);
                        oobTask.start();
                        try {
                            oobTask.join(TASK_RUN_TIME_MILLIS);
                        }
                        catch (InterruptedException e) {
                        }
                    }
                    return;
                }
            }, "Out of band notifier - Main");
            outOfBandNotifierThread.setDaemon(true);
            outOfBandNotifierThread.start();
        }

        public void shutdown() {
            this.shutdown = true;
            this.taskQueue.add(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
    }

    private static final class FiredEventsStatus {
        private ClusterInternal.ClusterEventType lastFiredEvent = null;

        private FiredEventsStatus() {
        }

        public synchronized void operationsDisabledFired() {
            this.lastFiredEvent = ClusterInternal.ClusterEventType.OPERATIONS_DISABLED;
            this.notifyAll();
        }

        public synchronized void operationsEnabledFired() {
            this.lastFiredEvent = ClusterInternal.ClusterEventType.OPERATIONS_ENABLED;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void waitUntilOperationsDisabledFired() {
            boolean interrupted = false;
            try {
                while (this.lastFiredEvent != ClusterInternal.ClusterEventType.OPERATIONS_DISABLED) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
            finally {
                Util.selfInterruptIfNeeded(interrupted);
            }
        }
    }
}

