/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.delivery;

import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.delivery.AbstractState;
import com.tc.net.protocol.delivery.AbstractStateMachine;
import com.tc.net.protocol.delivery.OOOProtocolMessage;
import com.tc.net.protocol.delivery.OOOProtocolMessageDelivery;
import com.tc.net.protocol.delivery.State;
import com.tc.properties.ReconnectConfig;
import com.tc.util.Assert;
import com.tc.util.Util;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendStateMachine
extends AbstractStateMachine {
    private final int sendQueueCap;
    final State HANDSHAKE_WAIT_STATE = new HandshakeWaitState();
    final State MESSAGE_WAIT_STATE = new MessageWaitState();
    final State ACK_PROCESSING_STATE = new AckProcessingState();
    final State SENDWINDOW_FULL_STATE = new SendWindowFullState();
    final State PAUSED_STATE = new PausedState();
    private final OOOProtocolMessageDelivery delivery;
    private final LinkedList<OOOProtocolMessage> outstandingMsgs = new LinkedList();
    private final int sendWindow;
    private final boolean isClient;
    private final String debugId;
    private static final boolean debug = false;
    private static final Logger logger = LoggerFactory.getLogger(SendStateMachine.class);
    private long sent = -1L;
    private long acked = -1L;
    private int outstandingCnt = 0;
    private LinkedBlockingQueue<TCNetworkMessage> sendQueue;

    public SendStateMachine(OOOProtocolMessageDelivery delivery, ReconnectConfig reconnectConfig, boolean isClient) {
        this.delivery = delivery;
        this.sendWindow = reconnectConfig.getSendWindow();
        int queueCap = reconnectConfig.getSendQueueCapacity();
        this.sendQueueCap = queueCap == 0 ? Integer.MAX_VALUE : queueCap;
        this.sendQueue = new LinkedBlockingQueue(this.sendQueueCap);
        this.isClient = isClient;
        this.debugId = this.isClient ? "CLIENT" : "SERVER";
    }

    @Override
    protected void basicResume() {
        this.switchToState(this.initialState());
    }

    @Override
    protected void basicPause() {
        this.switchToState(this.PAUSED_STATE);
    }

    @Override
    protected State initialState() {
        return this.HANDSHAKE_WAIT_STATE;
    }

    @Override
    public synchronized void execute(OOOProtocolMessage msg) {
        Assert.eval(this.isStarted());
        this.getCurrentState().execute(msg);
    }

    @Override
    public String toString() {
        return "CurrentState: " + this.getCurrentState() + "; OutStandingMsgsCount: " + this.outstandingCnt + "; Sent: " + this.sent + "; Acked: " + this.acked + "; " + super.toString();
    }

    @Override
    protected synchronized void switchToState(State state) {
        super.switchToState(state);
    }

    private void sendMoreIfAvailable() {
        while (!(this.sendWindow > 0 && this.outstandingCnt >= this.sendWindow || this.sendQueue.isEmpty())) {
            this.delivery.sendMessage(this.createProtocolMessage(++this.sent));
        }
    }

    private OOOProtocolMessage createProtocolMessage(long count) {
        OOOProtocolMessage opm = this.delivery.createProtocolMessage(count, SendStateMachine.dequeue(this.sendQueue));
        Assert.eval(opm != null);
        ++this.outstandingCnt;
        this.outstandingMsgs.add(opm);
        return opm;
    }

    private void resendOutstandings() {
        ListIterator<OOOProtocolMessage> it = this.outstandingMsgs.listIterator(0);
        while (it.hasNext()) {
            OOOProtocolMessage msg = it.next();
            this.delivery.sendMessage(msg);
        }
    }

    private void removeMessage() {
        OOOProtocolMessage msg = this.outstandingMsgs.removeFirst();
        msg.reallyDoRecycleOnWrite();
        --this.outstandingCnt;
        Assert.eval(this.outstandingCnt >= 0);
    }

    @Override
    public synchronized void reset() {
        this.sent = -1L;
        this.acked = -1L;
        this.outstandingCnt = 0;
        this.outstandingMsgs.clear();
        LinkedBlockingQueue<TCNetworkMessage> tmpQ = this.sendQueue;
        this.sendQueue = new LinkedBlockingQueue(this.sendQueueCap);
        tmpQ.clear();
    }

    private static TCNetworkMessage dequeue(LinkedBlockingQueue<TCNetworkMessage> q) {
        boolean interrupted = false;
        while (true) {
            try {
                TCNetworkMessage tCNetworkMessage = q.take();
                return tCNetworkMessage;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            Util.selfInterruptIfNeeded(interrupted);
        }
    }

    public void put(TCNetworkMessage message) throws InterruptedException {
        this.sendQueue.put(message);
    }

    private void debugLog(String msg) {
    }

    boolean isClean() {
        return this.sendQueue.isEmpty() && this.outstandingMsgs.isEmpty();
    }

    private class PausedState
    extends AbstractState {
        private PausedState() {
            super("PAUSED_STATE");
        }
    }

    private class SendWindowFullState
    extends AbstractState {
        public SendWindowFullState() {
            super("SEND_WINDOW_FULL_STATE");
        }

        @Override
        public void execute(OOOProtocolMessage protocolMessage) {
            if (protocolMessage == null) {
                return;
            }
            if (protocolMessage.isAck() || protocolMessage.isSend()) {
                SendStateMachine.this.switchToState(SendStateMachine.this.ACK_PROCESSING_STATE);
                SendStateMachine.this.getCurrentState().execute(protocolMessage);
            } else {
                Assert.failure("SEND_WINDOW_FULL_STATE doesn't expect this message: " + protocolMessage + ";\n" + this);
            }
        }
    }

    private class AckProcessingState
    extends AbstractState {
        public AckProcessingState() {
            super("ACK_PROCESSING_STATE");
        }

        @Override
        public void execute(OOOProtocolMessage protocolMessage) {
            if (protocolMessage == null) {
                return;
            }
            long ackedSeq = protocolMessage.getAckSequence();
            if (ackedSeq < SendStateMachine.this.acked) {
                // empty if block
            }
            while (ackedSeq > SendStateMachine.this.acked) {
                ++SendStateMachine.this.acked;
                SendStateMachine.this.removeMessage();
            }
            if (SendStateMachine.this.outstandingCnt < SendStateMachine.this.sendWindow) {
                SendStateMachine.this.switchToState(SendStateMachine.this.MESSAGE_WAIT_STATE);
            } else {
                SendStateMachine.this.switchToState(SendStateMachine.this.SENDWINDOW_FULL_STATE);
            }
        }
    }

    private class MessageWaitState
    extends AbstractState {
        public MessageWaitState() {
            super("MESSAGE_WAIT_STATE");
        }

        @Override
        public void enter() {
            this.execute(null);
        }

        @Override
        public void execute(OOOProtocolMessage protocolMessage) {
            if (protocolMessage != null) {
                SendStateMachine.this.switchToState(SendStateMachine.this.ACK_PROCESSING_STATE);
                SendStateMachine.this.getCurrentState().execute(protocolMessage);
            } else {
                SendStateMachine.this.sendMoreIfAvailable();
                if (SendStateMachine.this.sendWindow > 0 && SendStateMachine.this.outstandingCnt >= SendStateMachine.this.sendWindow) {
                    SendStateMachine.this.switchToState(SendStateMachine.this.SENDWINDOW_FULL_STATE);
                }
            }
        }
    }

    private class HandshakeWaitState
    extends AbstractState {
        public HandshakeWaitState() {
            super("HANDSHAKE_WAIT_STATE");
        }

        @Override
        public void execute(OOOProtocolMessage msg) {
            if (msg == null) {
                return;
            }
            if (!msg.isHandshakeReplyOk()) {
                logger.warn("Expecting only Handhake Reply messages. Dropping :" + msg + ";\n" + this);
                return;
            }
            long ackedSeq = msg.getAckSequence();
            if (ackedSeq == -1L) {
                SendStateMachine.this.switchToState(SendStateMachine.this.MESSAGE_WAIT_STATE);
                return;
            }
            if (ackedSeq >= SendStateMachine.this.acked) {
                logger.info("SENDER-" + SendStateMachine.this.debugId + "-" + SendStateMachine.this.delivery.getConnectionId() + "; AckSeq: " + ackedSeq + " Acked: " + SendStateMachine.this.acked);
                while (ackedSeq > SendStateMachine.this.acked) {
                    ++SendStateMachine.this.acked;
                    SendStateMachine.this.removeMessage();
                }
            }
            if (SendStateMachine.this.outstandingCnt > 0) {
                SendStateMachine.this.resendOutstandings();
                if (SendStateMachine.this.outstandingCnt >= SendStateMachine.this.sendWindow) {
                    SendStateMachine.this.switchToState(SendStateMachine.this.SENDWINDOW_FULL_STATE);
                } else {
                    SendStateMachine.this.switchToState(SendStateMachine.this.MESSAGE_WAIT_STATE);
                }
            } else {
                SendStateMachine.this.switchToState(SendStateMachine.this.MESSAGE_WAIT_STATE);
            }
        }
    }
}

