/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.sequence;

import com.tc.exception.TCRuntimeException;
import com.tc.util.sequence.BatchSequenceProvider;
import com.tc.util.sequence.BatchSequenceReceiver;
import com.tc.util.sequence.Sequence;
import com.tc.util.sequence.SequenceBatch;

public final class BatchSequence
implements BatchSequenceReceiver,
Sequence {
    private static final SequenceBatch NULL_SEQUENCE_BATCH = new SequenceBatch(0L, 0L);
    private SequenceBatch current = NULL_SEQUENCE_BATCH;
    private SequenceBatch nextBatch = NULL_SEQUENCE_BATCH;
    private boolean requestInProgress;
    private final BatchSequenceProvider remoteProvider;
    private final int batchSize;

    public BatchSequence(BatchSequenceProvider sequenceProvider, int batchSize) {
        this.remoteProvider = sequenceProvider;
        this.batchSize = batchSize;
    }

    @Override
    public synchronized long next() {
        this.requestMoreIDsIfNecessary();
        return this.current.next();
    }

    @Override
    public synchronized long current() {
        return this.current.current();
    }

    private void requestMoreIDsIfNecessary() {
        while (!this.current.hasNext() && !this.nextBatch.hasNext()) {
            if (!this.requestInProgress) {
                this.requestNextBatch();
            }
            try {
                if (this.current.hasNext() || this.nextBatch.hasNext()) continue;
                this.wait();
            }
            catch (InterruptedException ie) {
                throw new TCRuntimeException(ie);
            }
        }
        if (!this.current.hasNext()) {
            this.current = this.nextBatch;
            this.nextBatch = NULL_SEQUENCE_BATCH;
            this.requestNextBatch();
        }
    }

    private void requestNextBatch() {
        this.remoteProvider.requestBatch(this, this.batchSize);
        this.requestInProgress = true;
    }

    @Override
    public synchronized void setNextBatch(long start, long end) {
        this.nextBatch = new SequenceBatch(start, end);
        this.requestInProgress = false;
        this.notifyAll();
    }

    @Override
    public synchronized boolean isBatchRequestPending() {
        return !this.nextBatch.hasNext();
    }

    public synchronized BatchSequenceProvider getProvider() {
        return this.remoteProvider;
    }
}

