/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.net.core.ConnectionInfo;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.object.ClientEntityManager;
import com.tc.object.DistributedObjectClient;
import com.tc.object.config.ConnectionInfoConfig;
import com.tc.object.config.PreparedComponentsFromL2Connection;
import com.tc.object.handshakemanager.ClientHandshakeManager;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientShutdownManager {
    private static final Logger logger = LoggerFactory.getLogger(ClientShutdownManager.class);
    private final ClientMessageChannel channel;
    private final ClientHandshakeManager handshakeManager;
    private final PreparedComponentsFromL2Connection connectionComponents;
    private final Set<Runnable> beforeShutdown = new HashSet<Runnable>();
    private final DistributedObjectClient client;

    public ClientShutdownManager(DistributedObjectClient client, PreparedComponentsFromL2Connection connectionComponents) {
        this.client = client;
        this.channel = client.getChannel();
        this.handshakeManager = client.getClientHandshakeManager();
        this.connectionComponents = connectionComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBeforeShutdownHook(Runnable beforeShutdownHook) {
        Set<Runnable> set = this.beforeShutdown;
        synchronized (set) {
            this.beforeShutdown.add(beforeShutdownHook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBeforeShutdownHook(Runnable beforeShutdownHook) {
        Set<Runnable> set = this.beforeShutdown;
        synchronized (set) {
            this.beforeShutdown.remove(beforeShutdownHook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBeforeShutdownHooks() {
        Runnable[] beforeShutdowns;
        Set<Runnable> set = this.beforeShutdown;
        synchronized (set) {
            beforeShutdowns = this.beforeShutdown.toArray(new Runnable[this.beforeShutdown.size()]);
        }
        for (Runnable runnable : beforeShutdowns) {
            runnable.run();
        }
    }

    public void execute(boolean fromShutdownHook, boolean forceImmediate) {
        this.executeBeforeShutdownHooks();
        this.closeLocalWork(fromShutdownHook, forceImmediate);
        if (!fromShutdownHook) {
            this.shutdown();
        } else if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Throwable t) {
                logger.error("Error closing channel", t);
            }
        }
    }

    private void closeLocalWork(boolean fromShutdownHook, boolean forceImmediate) {
        this.handshakeManager.shutdown(fromShutdownHook);
        boolean immediate = forceImmediate || this.isImmediate();
        ClientEntityManager entityMgr = this.client.getEntityManager();
        if (entityMgr != null) {
            entityMgr.shutdown(fromShutdownHook);
        }
    }

    private boolean isImmediate() {
        if (this.channel.isConnected()) {
            return false;
        }
        ConnectionInfoConfig connectionInfoItem = this.connectionComponents.createConnectionInfoConfigItem();
        ConnectionInfo[] connectionInfo = connectionInfoItem.getConnectionInfos();
        return connectionInfo.length == 1;
    }

    private void shutdown() {
        this.client.shutdownResources();
    }
}

