/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.ClientID;
import com.tc.net.StripeID;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.net.protocol.transport.ConnectionIDFactoryListener;
import com.tc.util.ProductID;
import com.tc.util.UUID;

public class DefaultConnectionIdFactory
implements ConnectionIDFactory {
    private long sequence;
    private final String serverID = UUID.getUUID().toString();

    @Override
    public ConnectionID populateConnectionID(ConnectionID connectionID) {
        if (new ChannelID(connectionID.getChannelID()).isNull()) {
            return this.nextConnectionId(connectionID.getJvmID(), connectionID.getProductId());
        }
        return this.makeConnectionId(connectionID.getJvmID(), connectionID.getChannelID(), connectionID.getProductId());
    }

    private synchronized ConnectionID nextConnectionId(String clientJvmID, ProductID product) {
        return new ConnectionID(clientJvmID, this.sequence++, this.serverID, null, null, product);
    }

    private ConnectionID makeConnectionId(String clientJvmID, long channelID, ProductID product) {
        return new ConnectionID(clientJvmID, channelID, this.serverID, null, null, product);
    }

    @Override
    public void activate(StripeID stripeID, long nextAvailChannelID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerForConnectionIDEvents(ConnectionIDFactoryListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void restoreConnectionId(ConnectionID rv) {
    }

    @Override
    public long getCurrentConnectionID() {
        return this.sequence;
    }

    public String getServerID() {
        return this.serverID;
    }

    @Override
    public ConnectionID buildConnectionID(ClientID client) {
        return new ConnectionID("ffffffffffffffffffffffffffffffffffffffffffffffff", client.getChannelID().toLong(), this.serverID);
    }
}

