/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.config;

import com.tc.config.schema.CommonL1Config;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.L1ConfigurationSetupManager;
import com.tc.logging.CustomerLogging;
import com.tc.logging.TCLogger;
import com.tc.net.core.ConnectionInfo;
import com.tc.net.core.SecurityInfo;
import com.tc.object.config.ClientConfig;
import com.tc.object.config.ConnectionInfoConfig;
import com.tc.object.config.PreparedComponentsFromL2Connection;
import com.tc.properties.ReconnectConfig;
import com.tc.properties.TCPropertiesImpl;
import com.tc.security.PwProvider;
import com.tc.util.ProductInfo;
import com.tc.util.concurrent.ThreadUtil;
import com.tc.util.io.ServerURL;
import com.tc.util.version.Version;
import com.tc.util.version.VersionCompatibility;
import java.io.IOException;
import java.net.MalformedURLException;

public class ClientConfigImpl
implements ClientConfig {
    private static final TCLogger logger = CustomerLogging.getDSOGenericLogger();
    private final L1ConfigurationSetupManager configSetupManager;
    private final ReconnectConfig l1ReconnectConfig = null;
    private static final long CONFIGURATION_TOTAL_TIMEOUT = TCPropertiesImpl.getProperties().getLong("tc.config.total.timeout");

    public ClientConfigImpl(boolean initializedModulesOnlyOnce, L1ConfigurationSetupManager configSetupManager) {
        this(configSetupManager);
    }

    public ClientConfigImpl(L1ConfigurationSetupManager configSetupManager) {
        this.configSetupManager = configSetupManager;
    }

    @Override
    public String rawConfigText() {
        return this.configSetupManager.rawConfigText();
    }

    @Override
    public CommonL1Config getCommonL1Config() {
        return this.configSetupManager.commonL1Config();
    }

    @Override
    public SecurityInfo getSecurityInfo() {
        return this.configSetupManager.getSecurityInfo();
    }

    public String toString() {
        return "<ClientConfigImpl: " + this.configSetupManager + ">";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void validateClientServerCompatibility(PwProvider pwProvider, SecurityInfo securityInfo) throws ConfigurationSetupException {
        PreparedComponentsFromL2Connection connectionComponents = new PreparedComponentsFromL2Connection(this.configSetupManager);
        ConnectionInfoConfig connectionInfoItem = connectionComponents.createConnectionInfoConfigItem();
        ConnectionInfo[] connectionInfo = connectionInfoItem.getConnectionInfos();
        boolean foundCompatibleActive = false;
        boolean activeDown = false;
        int serverNumberInStripe = 0;
        long startTime = System.currentTimeMillis();
        long endTime = System.currentTimeMillis();
        while (endTime - startTime < CONFIGURATION_TOTAL_TIMEOUT) {
            ConnectionInfo connectionIn = new ConnectionInfo(connectionInfo[serverNumberInStripe].getHostname(), connectionInfo[serverNumberInStripe].getPort(), serverNumberInStripe, connectionInfo[serverNumberInStripe].getSecurityInfo());
            ServerURL serverUrl = null;
            try {
                String[] host = this.configSetupManager.source().split(":");
                serverUrl = new ServerURL(host[0], Integer.parseInt(host[1]), "/version", connectionIn.getSecurityInfo());
            }
            catch (MalformedURLException e) {
                throw new ConfigurationSetupException("Error while trying to verify Client-Server version Compatibility ");
            }
            String strServerVersion = null;
            try {
                strServerVersion = serverUrl.getHeaderField("Version", pwProvider, true);
                activeDown = false;
                logger.info("Server: " + serverUrl + " returned server version = " + strServerVersion);
            }
            catch (IOException e) {
                activeDown = true;
                logger.info("Server seems to be down.." + serverUrl + ", retrying next available in stripe");
            }
            if (strServerVersion == null) {
                block12: {
                    if (serverNumberInStripe == connectionInfo.length - 1) {
                        if (activeDown) {
                            ThreadUtil.reallySleep(500L);
                            serverNumberInStripe = 0;
                            break block12;
                        } else {
                            foundCompatibleActive = false;
                            break;
                        }
                    }
                    ++serverNumberInStripe;
                }
                endTime = System.currentTimeMillis();
                continue;
            }
            Version serverVersion = new Version(strServerVersion);
            foundCompatibleActive = this.checkServerClientVersion(serverVersion, serverUrl);
            break;
        }
        if (endTime - startTime > CONFIGURATION_TOTAL_TIMEOUT) {
            throw new ConfigurationSetupException("Timeout occured while trying to get Server Version, No Active server Found for : " + CONFIGURATION_TOTAL_TIMEOUT);
        }
        if (foundCompatibleActive) {
            return;
        }
        if (activeDown) {
            throw new IllegalStateException("At least one of the stripes is down, couldn't get the server version for compatibility check!");
        }
        throw new IllegalStateException("client Server Version mismatch occured: client version : " + this.getClientVersion() + " is not compatible with a server of Terracotta version: 4.0 or before");
    }

    private boolean checkServerClientVersion(Version serverVersion, ServerURL serverUrl) {
        Version clientVersion = this.getClientVersion();
        if (!new VersionCompatibility().isCompatibleClientServer(clientVersion, serverVersion)) {
            throw new IllegalStateException("Client-Server versions are incompatible: client version=" + clientVersion + ", serverVersion=" + serverVersion);
        }
        logger.debug("Found Compatible active Server = " + serverUrl);
        return true;
    }

    private Version getClientVersion() {
        return new Version(ProductInfo.getInstance().version());
    }

    private void setupL1ReconnectProperties(PwProvider pwProvider) throws ConfigurationSetupException {
    }

    @Override
    public synchronized ReconnectConfig getL1ReconnectProperties(PwProvider securityManager) throws ConfigurationSetupException {
        if (this.l1ReconnectConfig == null) {
            this.setupL1ReconnectProperties(securityManager);
        }
        return this.l1ReconnectConfig;
    }
}

