/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.logging.CustomerLogging;
import com.tc.logging.TCLogger;
import com.tc.net.protocol.transport.TransportHandshakeError;
import com.tc.net.protocol.transport.TransportHandshakeErrorContext;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandler;
import com.tc.util.concurrent.ThreadUtil;

public class TransportHandshakeErrorHandlerForL1
implements TransportHandshakeErrorHandler {
    private static final TCLogger consoleLogger = CustomerLogging.getConsoleLogger();

    @Override
    public void handleHandshakeError(TransportHandshakeErrorContext e) {
        if (e.getErrorType() == TransportHandshakeError.ERROR_STACK_MISMATCH) {
            consoleLogger.error(e.getMessage());
        } else if (e.getErrorType() != TransportHandshakeError.ERROR_RECONNECTION_REJECTED && e.getErrorType() != TransportHandshakeError.ERROR_NONE && e.getErrorType() != TransportHandshakeError.ERROR_REDIRECT_CONNECTION && e.getErrorType() != TransportHandshakeError.ERROR_NO_ACTIVE) {
            consoleLogger.error(e);
        }
        switch (e.getErrorType()) {
            case ERROR_STACK_MISMATCH: 
            case ERROR_MAX_CONNECTION_EXCEED: 
            case ERROR_RECONNECTION_REJECTED: 
            case ERROR_REDIRECT_CONNECTION: 
            case ERROR_NO_ACTIVE: 
            case ERROR_NONE: {
                break;
            }
            default: {
                ThreadUtil.reallySleep(30000L);
            }
        }
        switch (e.getErrorType()) {
            case ERROR_STACK_MISMATCH: 
            case ERROR_MAX_CONNECTION_EXCEED: 
            case ERROR_PRODUCT_NOT_SUPPORTED: {
                consoleLogger.error("Crashing the client due to handshake errors.");
                break;
            }
        }
    }
}

