/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.request;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.entity.VoltronEntityMultiResponse;
import com.tc.object.request.RequestResponseHandler;
import com.tc.object.tx.TransactionID;
import java.util.Map;

public class MultiRequestReceiveHandler
extends AbstractEventHandler<VoltronEntityMultiResponse> {
    private final RequestResponseHandler handler;

    public MultiRequestReceiveHandler(RequestResponseHandler handler) {
        this.handler = handler;
    }

    @Override
    public void handleEvent(VoltronEntityMultiResponse response) throws EventHandlerException {
        for (TransactionID received : response.getReceivedTransactions()) {
            this.handler.received(received);
        }
        Map<TransactionID, byte[]> results = response.getResults();
        for (Map.Entry<TransactionID, byte[]> entry : results.entrySet()) {
            byte[] result = entry.getValue();
            if (result == null) {
                this.handler.complete(entry.getKey());
                continue;
            }
            this.handler.complete(entry.getKey(), result);
        }
        for (TransactionID retires : response.getRetiredTransactions()) {
            this.handler.retired(retires);
        }
    }
}

