/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.entity.VoltronEntityMessage;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.InvocationHandler;
import com.tc.util.Assert;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.terracotta.entity.EndpointDelegate;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.InvocationBuilder;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.exception.EntityException;

public class EntityClientEndpointImpl<M extends EntityMessage, R extends EntityResponse>
implements EntityClientEndpoint<M, R> {
    private final InvocationHandler invocationHandler;
    private final byte[] configuration;
    private final EntityDescriptor invokeDescriptor;
    private final EntityID entityID;
    private final long version;
    private final MessageCodec<M, R> codec;
    private final Runnable closeHook;
    private EndpointDelegate delegate;
    private boolean isOpen;

    public EntityClientEndpointImpl(EntityID eid, long version, EntityDescriptor instance, InvocationHandler invocationHandler, byte[] entityConfiguration, MessageCodec<M, R> codec, Runnable closeHook) {
        this.entityID = eid;
        this.version = version;
        this.invokeDescriptor = instance;
        this.invocationHandler = invocationHandler;
        this.configuration = entityConfiguration;
        this.codec = codec;
        this.closeHook = closeHook;
        this.isOpen = true;
    }

    EntityID getEntityID() {
        return this.entityID;
    }

    long getVersion() {
        return this.version;
    }

    EntityDescriptor getEntityDescriptor() {
        return this.invokeDescriptor;
    }

    @Override
    public byte[] getEntityConfiguration() {
        this.checkEndpointOpen();
        return this.configuration;
    }

    @Override
    public void setDelegate(EndpointDelegate delegate) {
        this.checkEndpointOpen();
        Assert.assertNull(this.delegate);
        this.delegate = delegate;
    }

    public void handleMessage(byte[] message) throws MessageCodecException {
        if (null != this.delegate) {
            R messageFromServer = this.codec.decodeResponse(message);
            this.delegate.handleMessage((EntityResponse)messageFromServer);
        }
    }

    @Override
    public InvocationBuilder<M, R> beginInvoke() {
        this.checkEndpointOpen();
        return new InvocationBuilderImpl();
    }

    @Override
    public byte[] getExtendedReconnectData() {
        byte[] reconnectData = null;
        if (null != this.delegate) {
            reconnectData = this.delegate.createExtendedReconnectData();
        }
        if (null == reconnectData) {
            reconnectData = new byte[]{};
        }
        return reconnectData;
    }

    @Override
    public void close() {
        this.checkEndpointOpen();
        if (this.closeHook != null) {
            this.closeHook.run();
        }
        this.isOpen = false;
    }

    @Override
    public void didCloseUnexpectedly() {
        if (null != this.delegate) {
            this.delegate.didDisconnectUnexpectedly();
        }
    }

    private void checkEndpointOpen() {
        if (!this.isOpen) {
            throw new IllegalStateException("Endpoint closed");
        }
    }

    private class InvocationBuilderImpl
    implements InvocationBuilder<M, R> {
        private boolean invoked = false;
        private M request;
        private final Set<VoltronEntityMessage.Acks> acks = EnumSet.noneOf(VoltronEntityMessage.Acks.class);
        private boolean requiresReplication = true;
        private boolean shouldBlockGetOnRetire = true;

        private InvocationBuilderImpl() {
        }

        public synchronized InvocationBuilderImpl message(M request) {
            this.checkInvoked();
            this.request = request;
            return this;
        }

        @Override
        public InvocationBuilder<M, R> ackSent() {
            this.acks.add(VoltronEntityMessage.Acks.SENT);
            return this;
        }

        @Override
        public InvocationBuilder<M, R> ackReceived() {
            this.acks.add(VoltronEntityMessage.Acks.RECEIVED);
            return this;
        }

        @Override
        public InvocationBuilder<M, R> ackCompleted() {
            this.acks.add(VoltronEntityMessage.Acks.COMPLETED);
            return this;
        }

        @Override
        public InvocationBuilder<M, R> ackRetired() {
            this.acks.add(VoltronEntityMessage.Acks.RETIRED);
            return this;
        }

        @Override
        public InvocationBuilder<M, R> replicate(boolean requiresReplication) {
            this.requiresReplication = requiresReplication;
            return this;
        }

        @Override
        public InvocationBuilder<M, R> blockGetOnRetire(boolean shouldBlock) {
            this.shouldBlockGetOnRetire = shouldBlock;
            return this;
        }

        @Override
        public synchronized InvokeFuture<R> invoke() throws MessageCodecException {
            this.checkInvoked();
            this.invoked = true;
            final InvokeFuture<byte[]> invokeFuture = EntityClientEndpointImpl.this.invocationHandler.invokeAction(EntityClientEndpointImpl.this.invokeDescriptor, this.acks, this.requiresReplication, this.shouldBlockGetOnRetire, EntityClientEndpointImpl.this.codec.encodeMessage(this.request));
            return new InvokeFuture<R>(){

                @Override
                public boolean isDone() {
                    return invokeFuture.isDone();
                }

                @Override
                public R get() throws InterruptedException, EntityException {
                    try {
                        return EntityClientEndpointImpl.this.codec.decodeResponse((byte[])invokeFuture.get());
                    }
                    catch (MessageCodecException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public R getWithTimeout(long timeout, TimeUnit unit) throws InterruptedException, EntityException, TimeoutException {
                    try {
                        return EntityClientEndpointImpl.this.codec.decodeResponse((byte[])invokeFuture.getWithTimeout(timeout, unit));
                    }
                    catch (MessageCodecException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void interrupt() {
                    invokeFuture.interrupt();
                }
            };
        }

        private void checkInvoked() {
            if (this.invoked) {
                throw new IllegalStateException("Already invoked");
            }
        }
    }
}

