/*
 * Decompiled with CFR 0.152.
 */
package com.tc.client;

import com.tc.logging.LogLevel;
import com.tc.logging.LogLevels;
import com.tc.logging.TCLogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCLoggerClient
implements TCLogger {
    private final Logger base;

    public TCLoggerClient(Logger base) {
        this.base = base;
    }

    @Override
    public void debug(Object message) {
        this.base.finer(message.toString());
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.base.finer(message.toString());
        t.printStackTrace(new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                TCLoggerClient.this.base.finer(new String(cbuf, off, len));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        }));
    }

    @Override
    public void error(Object message) {
        this.base.warning(message.toString());
    }

    @Override
    public void error(Object message, Throwable t) {
        this.base.warning(message.toString());
        t.printStackTrace(new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                TCLoggerClient.this.base.warning(new String(cbuf, off, len));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        }));
    }

    @Override
    public void fatal(Object message) {
        this.base.severe(message.toString());
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.base.severe(message.toString());
        t.printStackTrace(new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                TCLoggerClient.this.base.severe(new String(cbuf, off, len));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        }));
    }

    @Override
    public void info(Object message) {
        this.base.info(message.toString());
    }

    @Override
    public void info(Object message, Throwable t) {
        this.base.info(message.toString());
        t.printStackTrace(new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                TCLoggerClient.this.base.info(new String(cbuf, off, len));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        }));
    }

    @Override
    public void warn(Object message) {
        this.base.warning(message.toString());
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.base.warning(message.toString());
        t.printStackTrace(new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                TCLoggerClient.this.base.warning(new String(cbuf, off, len));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        }));
    }

    @Override
    public boolean isDebugEnabled() {
        return this.base.isLoggable(Level.FINEST);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.base.isLoggable(Level.INFO);
    }

    @Override
    public void setLevel(LogLevel level) {
        this.base.setLevel(this.levelToBase(level));
    }

    @Override
    public LogLevel getLevel() {
        return this.baseToLevel(this.base.getLevel());
    }

    @Override
    public String getName() {
        return this.base.getName();
    }

    Level levelToBase(LogLevel level) {
        switch (level.getLevel()) {
            case 5: {
                return Level.FINEST;
            }
            case 4: {
                return Level.INFO;
            }
        }
        return Level.OFF;
    }

    LogLevel baseToLevel(Level level) {
        int iLevel = level.intValue();
        if (Level.FINEST.intValue() == iLevel) {
            return LogLevels.DEBUG;
        }
        if (Level.INFO.intValue() == iLevel) {
            return LogLevels.INFO;
        }
        return new LogLevel(){

            @Override
            public int getLevel() {
                return 0;
            }

            @Override
            public boolean isInfo() {
                return false;
            }
        };
    }
}

