/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management;

import com.tc.handler.LockInfoDumpHandler;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.management.AbstractTerracottaMBean;
import com.tc.management.TCClient;
import com.tc.management.beans.l1.L1InfoMBean;
import com.tc.properties.TCPropertiesImpl;
import com.tc.runtime.JVMMemoryManager;
import com.tc.runtime.TCRuntime;
import com.tc.util.ProductInfo;
import com.tc.util.StringUtil;
import com.tc.util.runtime.ThreadDumpUtil;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;

public class L1Info
extends AbstractTerracottaMBean
implements L1InfoMBean {
    private static final TCLogger logger = TCLogging.getLogger(L1Info.class);
    private static final MBeanNotificationInfo[] NOTIFICATION_INFO;
    private long nextSequenceNumber;
    private final ProductInfo productInfo = ProductInfo.getInstance();
    private final String buildID = this.productInfo.buildID();
    private final String rawConfigText;
    private final JVMMemoryManager manager;
    private final TCClient client;

    public L1Info(TCClient client, String rawConfigText) throws NotCompliantMBeanException {
        super(L1InfoMBean.class, true);
        this.manager = TCRuntime.getJVMMemoryManager();
        this.rawConfigText = rawConfigText;
        this.client = client;
        this.nextSequenceNumber = 1L;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return Arrays.asList(NOTIFICATION_INFO).toArray(EMPTY_NOTIFICATION_INFO);
    }

    private synchronized void _sendNotification(String msg, String attr, String type, Object oldVal, Object newVal) {
        this.sendNotification(new AttributeChangeNotification(this, this.nextSequenceNumber++, System.currentTimeMillis(), msg, attr, type, oldVal, newVal));
    }

    public L1Info(LockInfoDumpHandler lockInfoDumpHandler) throws NotCompliantMBeanException {
        super(L1InfoMBean.class, true);
        this.rawConfigText = null;
        this.manager = TCRuntime.getJVMMemoryManager();
        this.client = null;
        this.nextSequenceNumber = 1L;
    }

    @Override
    public String getVersion() {
        return this.productInfo.toShortString();
    }

    @Override
    public String getMavenArtifactsVersion() {
        return this.productInfo.mavenArtifactsVersion();
    }

    @Override
    public String getBuildID() {
        return this.buildID;
    }

    @Override
    public boolean isPatched() {
        return this.productInfo.isPatched();
    }

    @Override
    public String getPatchLevel() {
        return this.productInfo.patchLevel();
    }

    @Override
    public String getPatchVersion() {
        if (this.productInfo.isPatched()) {
            return this.productInfo.toLongPatchString();
        }
        return "";
    }

    @Override
    public String getPatchBuildID() {
        if (this.productInfo.isPatched()) {
            return this.productInfo.patchBuildID();
        }
        return "";
    }

    @Override
    public String getClientUUID() {
        return this.client.getUUID();
    }

    @Override
    public String getCopyright() {
        return this.productInfo.copyright();
    }

    @Override
    public String getEnvironment() {
        return this.format(System.getProperties());
    }

    @Override
    public String getTCProperties() {
        Properties props = TCPropertiesImpl.getProperties().addAllPropertiesTo(new Properties());
        String keyPrefix = null;
        return this.format(props, keyPrefix);
    }

    private String format(Properties properties) {
        return this.format(properties, null);
    }

    private String format(Properties properties, String keyPrefix) {
        StringBuffer sb = new StringBuffer();
        Enumeration<?> keys = properties.propertyNames();
        ArrayList<Object> l = new ArrayList<Object>();
        while (keys.hasMoreElements()) {
            Object o = keys.nextElement();
            if (!(o instanceof String)) continue;
            String key = (String)o;
            l.add(key);
        }
        Object[] props = l.toArray(new String[l.size()]);
        Arrays.sort(props);
        l.clear();
        l.addAll(Arrays.asList(props));
        int maxKeyLen = 0;
        for (String string : l) {
            maxKeyLen = Math.max(string.length(), maxKeyLen);
        }
        for (String string : l) {
            if (keyPrefix != null) {
                sb.append(keyPrefix);
            }
            sb.append(string);
            sb.append(":");
            int spaceLen = maxKeyLen - string.length() + 1;
            for (int i = 0; i < spaceLen; ++i) {
                sb.append(" ");
            }
            sb.append(properties.getProperty(string));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String[] getProcessArguments() {
        Object[] args = this.client.processArguments();
        List<String> inputArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (args == null) {
            return inputArgs.toArray(new String[inputArgs.size()]);
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add(StringUtil.toString(args, " ", null, null));
        l.addAll(inputArgs);
        return l.toArray(new String[l.size()]);
    }

    @Override
    public String getConfig() {
        return this.rawConfigText;
    }

    @Override
    public String takeThreadDump(long requestMillis) {
        String text = ThreadDumpUtil.getThreadDump();
        logger.info(text);
        return text;
    }

    @Override
    public byte[] takeCompressedThreadDump(long requestMillis) {
        return ThreadDumpUtil.getCompressedThreadDump();
    }

    @Override
    public Map<String, Object> getStatistics() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memory used", this.getUsedMemory());
        map.put("memory max", this.getMaxMemory());
        return map;
    }

    @Override
    public long getUsedMemory() {
        return this.manager.getMemoryUsage().getUsedMemory();
    }

    @Override
    public long getMaxMemory() {
        return this.manager.getMemoryUsage().getMaxMemory();
    }

    @Override
    public void reset() {
    }

    @Override
    public void gc() {
        ManagementFactory.getMemoryMXBean().gc();
    }

    @Override
    public boolean isVerboseGC() {
        return ManagementFactory.getMemoryMXBean().isVerbose();
    }

    @Override
    public void setVerboseGC(boolean verboseGC) {
        boolean oldValue = this.isVerboseGC();
        ManagementFactory.getMemoryMXBean().setVerbose(verboseGC);
        this._sendNotification("VerboseGC changed", "VerboseGC", "java.lang.Boolean", oldValue, verboseGC);
    }

    static {
        String[] notifTypes = new String[]{"jmx.attribute.change"};
        String name = AttributeChangeNotification.class.getName();
        String description = "An attribute of this MBean has changed";
        NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, name, "An attribute of this MBean has changed")};
    }
}

