/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.sequence;

import com.tc.util.sequence.BatchSequenceProvider;
import com.tc.util.sequence.BatchSequenceReceiver;
import com.tc.util.sequence.SequenceBatch;
import java.util.LinkedList;

public class GroupBatchSequenceProvider
implements BatchSequenceProvider,
BatchSequenceReceiver {
    private final int requestBatchSize;
    private final BatchSequenceProvider remoteSequenceProvider;
    private final LinkedList<Request> requests = new LinkedList();
    private SequenceBatch currentBatchIdsAvailable = new SequenceBatch(0L, 0L);
    private boolean isRequestInProgress = false;

    public GroupBatchSequenceProvider(BatchSequenceProvider sequenceProvider, int requestSize) {
        this.remoteSequenceProvider = sequenceProvider;
        this.requestBatchSize = requestSize;
    }

    @Override
    public synchronized boolean isBatchRequestPending() {
        int sizePresent = (int)(this.currentBatchIdsAvailable.end() - this.currentBatchIdsAvailable.current() - 1L);
        return sizePresent == 0 || this.isRequestInProgress;
    }

    @Override
    public synchronized void requestBatch(BatchSequenceReceiver receiver, int sizeRequested) {
        int sizePresent = (int)(this.currentBatchIdsAvailable.end() - this.currentBatchIdsAvailable.current() - 1L);
        if (sizePresent >= sizeRequested) {
            long end = this.currentBatchIdsAvailable.current() + 1L + (long)sizeRequested;
            receiver.setNextBatch(this.currentBatchIdsAvailable.current() + 1L, end);
            this.currentBatchIdsAvailable = new SequenceBatch(end, this.currentBatchIdsAvailable.end());
        } else {
            this.requests.addLast(new Request(receiver, sizeRequested));
            if (this.isRequestInProgress) {
                return;
            }
            this.isRequestInProgress = true;
            this.remoteSequenceProvider.requestBatch(this, this.requestBatchSize);
        }
    }

    @Override
    public synchronized void setNextBatch(long start, long end) {
        this.isRequestInProgress = false;
        this.currentBatchIdsAvailable = new SequenceBatch(start, end);
        for (int sizeOfList = this.requests.size(); sizeOfList > 0; --sizeOfList) {
            Request request = this.requests.removeFirst();
            this.requestBatch(request.getReciever(), request.getSize());
        }
    }

    private static class Request {
        private final BatchSequenceReceiver reciever;
        private final int size;

        public Request(BatchSequenceReceiver reciever, int size) {
            this.size = size;
            this.reciever = reciever;
        }

        public BatchSequenceReceiver getReciever() {
            return this.reciever;
        }

        public int getSize() {
            return this.size;
        }
    }
}

