/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.proxy;

import com.tc.util.StringUtil;
import com.tc.util.concurrent.ThreadUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class TCPProxy {
    private volatile boolean debug = false;
    private long delay;
    private final int listenPort;
    private final InetSocketAddress[] endpoints;
    private final AtomicInteger roundRobinSequence = new AtomicInteger(0);
    private ServerSocket serverSocket;
    private Thread acceptThread;
    private volatile boolean stop = false;
    private final Set<Connection> connections = new HashSet<Connection>();
    private final File logDir;
    private final boolean logData;
    private boolean reuseAddress = false;

    public TCPProxy(int listenPort, InetAddress destHost, int destPort, long delay, boolean logData, File logDir) {
        this(listenPort, new InetSocketAddress[]{new InetSocketAddress(destHost, destPort)}, delay, logData, logDir);
    }

    public TCPProxy(int listenPort, InetSocketAddress[] endpoints, long delay, boolean logData, File logDir) {
        this.listenPort = listenPort;
        this.endpoints = endpoints;
        this.logData = logData;
        this.logDir = logDir;
        this.setDelay(delay);
        this.verifyEndpoints();
    }

    private void verifyEndpoints() {
        for (InetSocketAddress addr : this.endpoints) {
            if (addr.getAddress() != null) continue;
            throw new RuntimeException("Cannot resolve address for host " + addr.getHostName());
        }
    }

    public void setReuseAddress(boolean reuse) {
        this.reuseAddress = reuse;
    }

    public boolean probeBackendConnection() {
        Socket connectedSocket = null;
        for (int pos = 0; pos < this.endpoints.length; ++pos) {
            int roundRobinOffset = (pos + this.roundRobinSequence.get()) % this.endpoints.length;
            try {
                connectedSocket = new Socket(this.endpoints[roundRobinOffset].getAddress(), this.endpoints[roundRobinOffset].getPort());
                break;
            }
            catch (IOException ioe) {
                continue;
            }
        }
        if (connectedSocket != null) {
            try {
                connectedSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public synchronized void start() throws IOException {
        if (this.acceptThread != null) {
            TCPProxy.log("Stop previous accept thread before start a new one");
            this.fastStop();
        }
        TCPProxy.log("Starting listener on port " + this.listenPort + ", proxying to " + StringUtil.toString(this.endpoints, ", ", "[", "]") + " with " + this.getDelay() + "ms delay");
        if (!this.reuseAddress) {
            this.serverSocket = new ServerSocket(this.listenPort);
        } else {
            this.serverSocket = new ServerSocket();
            this.serverSocket.setReuseAddress(true);
            try {
                this.serverSocket.bind(new InetSocketAddress(this.listenPort), 500);
            }
            catch (IOException e) {
                this.serverSocket.close();
                throw new RuntimeException("Failed to bind port " + this.listenPort + " is bad: " + e);
            }
        }
        this.stop = false;
        final TCPProxy ME = this;
        this.acceptThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ME.run();
            }
        }, "Accept thread (port " + this.listenPort + ")");
        int count = 0;
        while (true) {
            try {
                Socket sk = new Socket("localhost", this.listenPort);
                sk.close();
                break;
            }
            catch (Exception e) {
                if (++count > 10) {
                    throw new RuntimeException("Listen socket at " + this.listenPort + " is bad: " + e);
                }
                TCPProxy.log("Listen socket at " + this.listenPort + " is bad: " + e);
                this.serverSocket.close();
                ThreadUtil.reallySleep(100L);
                TCPProxy.log("Rebind listen socket at " + this.listenPort);
                this.serverSocket = new ServerSocket();
                this.serverSocket.setReuseAddress(true);
                try {
                    this.serverSocket.bind(new InetSocketAddress(this.listenPort), 500);
                }
                catch (IOException ee) {
                    this.serverSocket.close();
                    throw new RuntimeException("Failed to bind port " + this.listenPort + " is bad: " + ee);
                }
            }
        }
        this.acceptThread.setDaemon(true);
        this.acceptThread.start();
    }

    public synchronized void fastStop() {
        this.subStop(false);
    }

    public synchronized void stop() {
        this.subStop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void subStop(boolean waitDeadThread) {
        this.stop = true;
        if (this.acceptThread == null) {
            return;
        }
        this.acceptThread.interrupt();
        while (true) {
            try {
                Socket sk = new Socket("localhost", this.listenPort);
                sk.close();
            }
            catch (Exception x) {
                break;
            }
            ThreadUtil.reallySleep(100L);
        }
        try {
            try {
                this.acceptThread.join(10000L);
            }
            catch (InterruptedException e) {
                TCPProxy.log("Interrupted while join()'ing acceptor thread", e);
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.acceptThread = null;
        }
        this.closeAllConnections(waitDeadThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeClientConnections(boolean waitDeadThread, boolean split) {
        Connection[] conns;
        Set<Connection> set = this.connections;
        synchronized (set) {
            conns = this.connections.toArray(new Connection[0]);
        }
        for (Connection conn : conns) {
            try {
                conn.closeClientHalf(waitDeadThread, split);
            }
            catch (Exception e) {
                TCPProxy.log("Error closing client-side connection " + conn.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeAllConnections(boolean waitDeadThread) {
        Connection[] conns;
        Set<Connection> set = this.connections;
        synchronized (set) {
            conns = this.connections.toArray(new Connection[0]);
        }
        for (Connection conn : conns) {
            try {
                conn.close(waitDeadThread);
            }
            catch (Exception e) {
                TCPProxy.log("Error closing connection " + conn.toString(), e);
            }
        }
    }

    public void toggleDebug() {
        this.debug = !this.debug;
    }

    public synchronized long getDelay() {
        return this.delay;
    }

    public synchronized void setDelay(long newDelay) {
        if (newDelay < 0L) {
            throw new IllegalArgumentException("Delay must be greater than or equal to zero");
        }
        this.delay = newDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interrupt() {
        Connection[] conns;
        Set<Connection> set = this.connections;
        synchronized (set) {
            conns = this.connections.toArray(new Connection[0]);
        }
        for (Connection conn : conns) {
            conn.interrupt();
        }
    }

    private void run() {
        while (!this.stop) {
            Socket socket;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException ioe) {
                TCPProxy.log("Accept error " + ioe);
                continue;
            }
            if (Thread.interrupted() || socket == null) continue;
            this.debug("Accepted connection from " + socket.toString());
            try {
                new Connection(socket, this, this.logData, this.logDir);
            }
            catch (IOException ioe) {
                TCPProxy.log("Error connecting to any of remote hosts " + StringUtil.toString(this.endpoints, ", ", "[", "]") + ", " + ioe.getMessage());
                try {
                    socket.close();
                }
                catch (IOException clientIOE) {
                    TCPProxy.log("Unable to close client socket after failing to proxy: " + clientIOE.getMessage());
                }
            }
        }
        try {
            this.serverSocket.close();
            this.serverSocket = null;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to close client socket " + e);
        }
    }

    private int getAndIncrementRoundRobinSequence() {
        return this.roundRobinSequence.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregister(Connection connection) {
        Set<Connection> set = this.connections;
        synchronized (set) {
            this.connections.remove(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(Connection connection) {
        Set<Connection> set = this.connections;
        synchronized (set) {
            this.connections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void status() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            Connection[] conns;
            System.err.println();
            System.err.println("Listening on port : " + this.listenPort);
            System.err.println("Connection delay  : " + this.getDelay() + "ms");
            System.err.println("Proxying to       : " + StringUtil.toString(this.endpoints, ", ", "[", "]"));
            System.err.println("Debug Logging     : " + this.debug);
            System.err.println("Active connections:");
            Set<Connection> set = this.connections;
            synchronized (set) {
                conns = this.connections.toArray(new Connection[0]);
            }
            for (int i = 0; i < conns.length; ++i) {
                System.err.println("\t" + i + ": " + conns[i].toString());
            }
            if (conns.length == 0) {
                System.err.println("\tNONE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void help() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            System.err.println();
            System.err.println("h       - this help message");
            System.err.println("s       - print proxy status");
            System.err.println("d <num> - adjust the delay time to <num> milliseconds");
            System.err.println("c       - close all active connections");
            System.err.println("l       - toggle debug logging");
            System.err.println("q       - quit (shutdown proxy)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length < 2 || args.length > 3) {
            TCPProxy.usage();
            System.exit(1);
        }
        int listenPort = Integer.valueOf(args[0]);
        String[] endpointStrings = args[1].split(",");
        InetSocketAddress[] endpoints = new InetSocketAddress[endpointStrings.length];
        for (int pos = 0; pos < endpointStrings.length; ++pos) {
            int separatorIdx = endpointStrings[pos].indexOf(":");
            endpoints[pos] = new InetSocketAddress(endpointStrings[pos].substring(0, separatorIdx), Integer.parseInt(endpointStrings[pos].substring(separatorIdx + 1)));
        }
        long delay = 0L;
        if (args.length == 3) {
            delay = Long.valueOf(args[2]);
        }
        boolean daemonMode = Boolean.getBoolean("daemon");
        TCPProxy theProxy = new TCPProxy(listenPort, endpoints, delay, false, null);
        theProxy.start();
        if (daemonMode) {
            Thread.currentThread().join();
        } else {
            try {
                BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
                String line = "";
                TCPProxy.prompt();
                while ((line = stdin.readLine()) != null) {
                    if ((line = line.trim()).toLowerCase().startsWith("q")) {
                        break;
                    }
                    try {
                        if (line.toLowerCase().startsWith("h")) {
                            TCPProxy.help();
                            continue;
                        }
                        if (line.toLowerCase().startsWith("s")) {
                            theProxy.status();
                            continue;
                        }
                        if (line.toLowerCase().startsWith("c")) {
                            theProxy.closeAllConnections(true);
                            TCPProxy.out("all connections closed");
                            continue;
                        }
                        if (line.toLowerCase().startsWith("l")) {
                            theProxy.toggleDebug();
                            TCPProxy.out("debug logging toggled");
                            continue;
                        }
                        if (!line.toLowerCase().startsWith("d")) continue;
                        if (line.length() <= 2) {
                            TCPProxy.out("you must supply a delay value");
                            continue;
                        }
                        try {
                            theProxy.setDelay(Long.valueOf(line.substring(2)));
                            theProxy.interrupt();
                        }
                        catch (Exception e) {
                            TCPProxy.out(e);
                        }
                    }
                    catch (Exception e) {
                        TCPProxy.out(e);
                    }
                    finally {
                        TCPProxy.prompt();
                    }
                }
            }
            finally {
                theProxy.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prompt() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            System.err.print("\nproxy> ");
            System.err.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void out(String message) {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            System.err.println(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void out(Throwable t) {
        if (t == null) {
            return;
        }
        PrintStream printStream = System.err;
        synchronized (printStream) {
            t.printStackTrace(System.err);
        }
    }

    private static void log(String message) {
        TCPProxy.log(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(String message, Throwable t) {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            System.err.println(new Date() + ": " + message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }

    private void debug(String message) {
        this.debug(message, null);
    }

    private void debug(String message, Throwable t) {
        if (this.debug) {
            TCPProxy.log(message, t);
        }
    }

    private static void usage() {
        System.err.println("usage: TCPProxy <listen port> <endpoint[,endpoint...]> [delay]");
        System.err.println("    <listen port> - The port the proxy should listen on");
        System.err.println("       <endpoint> - Comma separated list of 1 or more <host>:<port> pairs to round robin requests to");
        System.err.println("          [delay] - Millisecond delay between network data (optional, default: 0)");
    }

    private static class Connection {
        private final Socket client;
        private final Socket proxy;
        private final TCPProxy parent;
        private final Thread clientThread;
        private final Thread proxyThread;
        private final Object closeLock = new Object();
        private volatile boolean stopConn = false;
        private final long connectTime;
        private long lastActivity;
        private long clientBytesIn = 0L;
        private long proxyBytesIn = 0L;
        private final OutputStream clientLog;
        private final OutputStream proxyLog;
        private volatile boolean allowSplit = false;

        Connection(Socket client, TCPProxy parent, boolean logData, File logDir) throws IOException {
            this.parent = parent;
            this.client = client;
            this.lastActivity = this.connectTime = System.currentTimeMillis();
            IOException lastConnectException = null;
            Socket connectedSocket = null;
            int roundRobinSequence = parent.getAndIncrementRoundRobinSequence();
            for (int pos = 0; pos < parent.endpoints.length; ++pos) {
                int roundRobinOffset = (pos + roundRobinSequence) % parent.endpoints.length;
                try {
                    connectedSocket = new Socket(parent.endpoints[roundRobinOffset].getAddress(), parent.endpoints[roundRobinOffset].getPort());
                    break;
                }
                catch (IOException ioe) {
                    lastConnectException = ioe;
                    continue;
                }
            }
            if (connectedSocket == null) {
                IOException ioe = lastConnectException != null ? lastConnectException : new IOException("Unable to establish a proxy connection to a back end server: " + StringUtil.toString(parent.endpoints, ",", "[", "]"));
                throw ioe;
            }
            this.proxy = connectedSocket;
            if (logData) {
                String log = client.getLocalAddress().getHostName().toString() + "." + client.getPort();
                this.clientLog = new FileOutputStream(new File(logDir, log + ".in"), false);
                this.proxyLog = new FileOutputStream(new File(logDir, log + ".out"), false);
            } else {
                this.clientLog = null;
                this.proxyLog = null;
            }
            this.proxy.setSoTimeout(100);
            client.setSoTimeout(100);
            this.proxy.setTcpNoDelay(true);
            client.setTcpNoDelay(true);
            final InputStream clientIs = client.getInputStream();
            final OutputStream clientOs = client.getOutputStream();
            final InputStream proxyIs = this.proxy.getInputStream();
            final OutputStream proxyOs = this.proxy.getOutputStream();
            parent.register(this);
            this.clientThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Connection.this.runHalf(clientIs, proxyOs, true, Connection.this.clientLog, Connection.this.client);
                }
            }, "Client thread for connection " + client + " proxy to " + this.proxy);
            this.proxyThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Connection.this.runHalf(proxyIs, clientOs, false, Connection.this.proxyLog, Connection.this.proxy);
                }
            }, "Proxy thread for connection " + client + " proxy to " + this.proxy);
            this.clientThread.start();
            this.proxyThread.start();
        }

        private synchronized void activity() {
            this.lastActivity = System.currentTimeMillis();
        }

        private synchronized long getLastActivity() {
            return this.lastActivity;
        }

        private synchronized void addProxyBytesIn(long bytesIn) {
            this.proxyBytesIn += bytesIn;
        }

        private synchronized void addClientBytesIn(long bytesIn) {
            this.clientBytesIn += bytesIn;
        }

        private synchronized long getProxyBytesIn() {
            return this.proxyBytesIn;
        }

        private synchronized long getClientBytesIn() {
            return this.clientBytesIn;
        }

        public String toString() {
            return "Client: " + this.client + ", proxy to: " + this.proxy + ", connect: " + new Date(this.connectTime) + ", idle: " + (System.currentTimeMillis() - this.getLastActivity()) + ", bytes from client: " + this.getClientBytesIn() + ", bytes from endpoint: " + this.getProxyBytesIn();
        }

        private void delay() {
            long sleep = this.parent.getDelay();
            if (sleep > 0L) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void runHalf(InputStream src, OutputStream dest, boolean isClientHalf, OutputStream log, Socket s) {
            byte[] buffer = new byte[4096];
            while (!this.stopConn) {
                int bytesRead;
                block33: {
                    bytesRead = 0;
                    bytesRead = src.read(buffer);
                    if (bytesRead <= 0) break block33;
                    try {
                        if (log != null) {
                            log.write(buffer, 0, bytesRead);
                            log.flush();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.parent.debug("read " + bytesRead + " on " + (isClientHalf ? "client" : "proxy") + " connection");
                    if (isClientHalf) {
                        this.addClientBytesIn(bytesRead);
                    } else {
                        this.addProxyBytesIn(bytesRead);
                    }
                    break block33;
                    catch (SocketTimeoutException ste) {
                        bytesRead = ste.bytesTransferred;
                        if (bytesRead <= 0) break block33;
                        try {
                            if (log != null) {
                                log.write(buffer, 0, bytesRead);
                                log.flush();
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        this.parent.debug("read " + bytesRead + " on " + (isClientHalf ? "client" : "proxy") + " connection");
                        if (isClientHalf) {
                            this.addClientBytesIn(bytesRead);
                        } else {
                            this.addProxyBytesIn(bytesRead);
                        }
                    }
                    catch (IOException ioe) {
                        block34: {
                            this.parent.debug("IOException on " + (isClientHalf ? "client" : "proxy") + " connection", ioe);
                            if (bytesRead <= 0) break block34;
                            {
                                catch (Throwable throwable) {
                                    if (bytesRead > 0) {
                                        try {
                                            if (log != null) {
                                                log.write(buffer, 0, bytesRead);
                                                log.flush();
                                            }
                                        }
                                        catch (IOException e) {
                                            throw new RuntimeException(e);
                                        }
                                        this.parent.debug("read " + bytesRead + " on " + (isClientHalf ? "client" : "proxy") + " connection");
                                        if (isClientHalf) {
                                            this.addClientBytesIn(bytesRead);
                                        } else {
                                            this.addProxyBytesIn(bytesRead);
                                        }
                                    }
                                    throw throwable;
                                }
                            }
                            try {
                                if (log != null) {
                                    log.write(buffer, 0, bytesRead);
                                    log.flush();
                                }
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            this.parent.debug("read " + bytesRead + " on " + (isClientHalf ? "client" : "proxy") + " connection");
                            if (isClientHalf) {
                                this.addClientBytesIn(bytesRead);
                            } else {
                                this.addProxyBytesIn(bytesRead);
                            }
                        }
                        return;
                    }
                }
                if (bytesRead < 0) {
                    if (!this.allowSplit) {
                        this.close(true);
                    }
                    return;
                }
                if (bytesRead <= 0) continue;
                this.activity();
                this.delay();
                try {
                    dest.write(buffer, 0, bytesRead);
                    dest.flush();
                }
                catch (IOException ioe) {
                    if (!this.allowSplit) {
                        this.close(true);
                    }
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void interrupt() {
            try {
                this.clientThread.interrupt();
            }
            finally {
                this.proxyThread.interrupt();
            }
        }

        void closeClientHalf(boolean wait, boolean split) {
            this.allowSplit = split;
            try {
                Connection.closeHalf(this.client, this.clientThread, this.clientLog, wait);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        void closeProxyHalf(boolean wait, boolean split) {
            this.allowSplit = split;
            try {
                Connection.closeHalf(this.proxy, this.proxyThread, this.proxyLog, wait);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void closeHalf(Socket socket, Thread thread, OutputStream out, boolean wait) {
            try {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                thread.interrupt();
                if (wait) {
                    try {
                        thread.join(1000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(boolean waitDeadThread) {
            Object object = this.closeLock;
            synchronized (object) {
                if (this.stopConn) {
                    return;
                }
                this.stopConn = true;
            }
            try {
                this.closeClientHalf(waitDeadThread, false);
                this.closeProxyHalf(waitDeadThread, false);
            }
            finally {
                this.parent.deregister(this);
            }
        }
    }
}

