/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net;

import com.tc.exception.TCRuntimeException;
import com.tc.net.core.ConnectionInfo;
import com.tc.util.Assert;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class TCSocketAddress {
    private static final byte[] WILDCARD_BYTES = new byte[]{0, 0, 0, 0};
    private static final byte[] LOOPBACK_BYTES = new byte[]{127, 0, 0, 1};
    public static final String LOOPBACK_IP = "127.0.0.1";
    public static final String WILDCARD_IP = "0.0.0.0";
    public static final InetAddress WILDCARD_ADDR;
    public static final InetAddress LOOPBACK_ADDR;
    private String stringForm;
    private String canonicalStringForm;
    private final InetAddress addr;
    private final int port;

    public static byte[] getLoopbackBytes() {
        return (byte[])LOOPBACK_BYTES.clone();
    }

    public static byte[] getWilcardBytes() {
        return (byte[])WILDCARD_BYTES.clone();
    }

    public TCSocketAddress(ConnectionInfo connInfo) throws UnknownHostException {
        this(connInfo.getHostname(), connInfo.getPort());
    }

    public TCSocketAddress(int port) {
        this(LOOPBACK_ADDR, port);
    }

    public TCSocketAddress(String host, int port) throws UnknownHostException {
        this(InetAddress.getByName(host), port);
    }

    public TCSocketAddress(InetAddress addr, int port) {
        if (!TCSocketAddress.isValidPort(port)) {
            throw new IllegalArgumentException("port (" + port + ") is out of range (0 - 0xFFFF)");
        }
        if (addr == null) {
            try {
                addr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                addr = LOOPBACK_ADDR;
            }
        }
        this.addr = addr;
        this.port = port;
        Assert.eval(this.addr != null);
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public byte[] getAddressBytes() {
        return this.addr.getAddress();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TCSocketAddress) {
            TCSocketAddress other = (TCSocketAddress)obj;
            return this.port == other.port && this.addr.equals(other.addr);
        }
        return false;
    }

    public int hashCode() {
        if (this.addr == null) {
            return super.hashCode();
        }
        return this.addr.hashCode() + this.port;
    }

    public String toString() {
        return this.getStringForm();
    }

    public String getStringForm() {
        if (this.stringForm == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.addr.getHostAddress()).append(":").append(this.port);
            this.stringForm = buf.toString();
        }
        return this.stringForm;
    }

    public String getCanonicalStringForm() {
        if (this.canonicalStringForm == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.addr.getCanonicalHostName()).append(":").append(this.port);
            this.canonicalStringForm = buf.toString();
        }
        return this.canonicalStringForm;
    }

    public static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    static {
        try {
            WILDCARD_ADDR = InetAddress.getByName(WILDCARD_IP);
        }
        catch (UnknownHostException e) {
            throw new TCRuntimeException("Cannot create InetAddress instance for 0.0.0.0");
        }
        try {
            LOOPBACK_ADDR = InetAddress.getByName(LOOPBACK_IP);
        }
        catch (UnknownHostException e) {
            throw new TCRuntimeException("Cannot create InetAddress instance for 127.0.0.1");
        }
    }
}

