/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.diagnostic;

import com.tc.entity.DiagnosticMessage;
import com.tc.entity.VoltronEntityMessage;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ClientEntityManager;
import com.tc.object.EntityClientEndpointImpl;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.InFlightMessage;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.object.tx.TransactionID;
import com.tc.text.PrettyPrinter;
import com.tc.util.Assert;
import com.terracotta.diagnostic.Diagnostics;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.entity.MessageCodec;
import org.terracotta.exception.EntityException;

public class DiagnosticClientEntityManager
implements ClientEntityManager {
    private final ClientMessageChannel channel;
    private final AtomicLong tid = new AtomicLong();
    private final Map<TransactionID, InFlightMessage> waitingForAnswer = new ConcurrentHashMap<TransactionID, InFlightMessage>();

    public DiagnosticClientEntityManager(ClientMessageChannel channel) {
        this.channel = channel;
    }

    @Override
    public EntityClientEndpoint fetchEntity(EntityDescriptor entityDescriptor, MessageCodec<? extends EntityMessage, ? extends EntityResponse> codec, Runnable closeHook) throws EntityException {
        EntityID eid = entityDescriptor.getEntityID();
        Assert.assertEquals(Diagnostics.class.getName(), eid.getClassName());
        Assert.assertEquals("root", eid.getEntityName());
        return new EntityClientEndpointImpl<EntityMessage, EntityResponse>(entityDescriptor, this, new byte[0], codec, closeHook);
    }

    @Override
    public void handleMessage(EntityDescriptor entityDescriptor, byte[] message) {
    }

    @Override
    public byte[] createEntity(EntityID entityID, long version, byte[] config) throws EntityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean destroyEntity(EntityID entityID, long version) throws EntityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] reconfigureEntity(EntityID entityID, long version, byte[] config) throws EntityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrettyPrinter prettyPrint(PrettyPrinter out) {
        return out;
    }

    @Override
    public void received(TransactionID id) {
    }

    @Override
    public void complete(TransactionID id) {
    }

    @Override
    public void complete(TransactionID id, byte[] value) {
        this.waitingForAnswer.remove(id).setResult(value, null);
    }

    @Override
    public void failed(TransactionID id, EntityException e) {
    }

    @Override
    public void retired(TransactionID id) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void unpause() {
    }

    @Override
    public void initializeHandshake(ClientHandshakeMessage handshakeMessage) {
    }

    @Override
    public void shutdown(boolean fromShutdownHook) {
    }

    @Override
    public InvokeFuture<byte[]> invokeAction(EntityDescriptor entityDescriptor, Set<VoltronEntityMessage.Acks> acks, boolean requiresReplication, boolean shouldBlockGetOnRetire, byte[] payload) {
        DiagnosticMessage network = this.createMessage(payload);
        InFlightMessage message = new InFlightMessage(network, Collections.<VoltronEntityMessage.Acks>emptySet(), false);
        this.waitingForAnswer.put(network.getTransactionID(), message);
        network.send();
        return message;
    }

    private DiagnosticMessage createMessage(byte[] config) {
        TransactionID transactionID = new TransactionID(this.tid.incrementAndGet());
        DiagnosticMessage message = (DiagnosticMessage)this.channel.createMessage(TCMessageType.DIAGNOSTIC_REQUEST);
        Assert.assertNotNull(config);
        message.setContents(transactionID, config);
        return message;
    }
}

