/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol;

import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.core.ConnectionInfo;
import com.tc.net.core.TCConnection;
import com.tc.net.protocol.IllegalReconnectException;
import com.tc.net.protocol.NetworkStackHarness;
import com.tc.net.protocol.NetworkStackID;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.MessageChannelInternal;
import com.tc.net.protocol.tcm.ServerMessageChannelFactory;
import com.tc.net.protocol.transport.ClientConnectionEstablisher;
import com.tc.net.protocol.transport.ClientMessageTransport;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionWatcher;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportFactory;
import com.tc.net.protocol.transport.MessageTransportInitiator;
import com.tc.util.Assert;
import com.tc.util.TCTimeoutException;
import com.tc.util.concurrent.SetOnceFlag;
import java.io.IOException;
import java.util.Collection;

public abstract class AbstractNetworkStackHarness
implements NetworkStackHarness {
    protected MessageTransport transport;
    protected MessageChannelInternal channel;
    private final ServerMessageChannelFactory channelFactory;
    private final MessageTransportFactory transportFactory;
    private final boolean isClientStack;
    private final SetOnceFlag finalized = new SetOnceFlag();

    protected AbstractNetworkStackHarness(ServerMessageChannelFactory channelFactory, MessageTransport transport) {
        this.channelFactory = channelFactory;
        this.transportFactory = null;
        this.transport = transport;
        this.isClientStack = false;
    }

    protected AbstractNetworkStackHarness(MessageTransportFactory transportFactory, MessageChannelInternal channel) {
        this.transportFactory = transportFactory;
        this.channelFactory = null;
        this.channel = channel;
        this.isClientStack = true;
    }

    @Override
    public final MessageTransport attachNewConnection(TCConnection connection) throws IllegalReconnectException {
        Assert.eval("Attempt to connect a transport to a stack that hasn't been finalized.", this.finalized.isSet());
        this.transport.attachNewConnection(connection);
        return this.transport;
    }

    @Override
    public final void finalizeStack() {
        if (this.finalized.attemptSet()) {
            if (this.isClientStack) {
                Assert.assertNotNull(this.channel);
                Assert.assertNotNull(this.transportFactory);
                this.transport = this.transportFactory.createNewTransport();
            } else {
                Assert.assertNotNull(this.transport);
                Assert.assertNotNull(this.channelFactory);
                this.channel = this.channelFactory.createNewChannel(new ChannelID(this.transport.getConnectionId().getChannelID()), this.transport.getConnectionId().getProductId());
            }
        } else {
            throw Assert.failure("Attempt to finalize an already finalized stack");
        }
        this.createIntermediateLayers();
        this.connectStack(this.isClientStack);
    }

    protected ClientConnectionEstablisher createClientConnectionEstablisher() {
        return this.transportFactory.createClientConnectionEstablisher();
    }

    protected void connectStack(boolean isClientStack) {
        this.transport.setReceiveLayer(this.channel);
        if (isClientStack) {
            final ClientMessageTransport cmt = (ClientMessageTransport)this.transport;
            ClientMessageChannel cmc = (ClientMessageChannel)((Object)this.channel);
            final ClientConnectionEstablisher cce = this.createClientConnectionEstablisher();
            cmc.setMessageTransportInitiator(new MessageTransportInitiator(){

                @Override
                public NetworkStackID openMessageTransport(Collection<ConnectionInfo> dest, ConnectionID connection) throws CommStackMismatchException, IOException, MaxConnectionsExceededException, TCTimeoutException {
                    AbstractNetworkStackHarness.this.channel.setSendLayer(AbstractNetworkStackHarness.this.transport);
                    cmt.initConnectionID(connection);
                    return cce.open(dest, cmt);
                }
            });
            ConnectionWatcher cw = new ConnectionWatcher(cmt, this.channel, cce);
            this.transport.addTransportListener(cw);
        } else {
            this.channel.setSendLayer(this.transport);
            this.transport.addTransportListener(this.channel);
        }
    }

    protected abstract void createIntermediateLayers();

    public String toString() {
        return "AbstractNetworkStackHarness[ transport:" + this.transport + "channel" + this.channel + ",isclientStack:" + this.isClientStack + "]";
    }
}

