/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.l2.msg.ReplicationResultCode;
import com.tc.l2.msg.SyncReplicationActivity;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ReplicationMessageAck
extends AbstractGroupMessage {
    public static final int INVALID = 0;
    public static final int START_SYNC = 4;
    public static final int BATCH = 5;
    private List<Tuple> batch;

    public static ReplicationMessageAck createSyncRequestMessage() {
        return new ReplicationMessageAck(4);
    }

    public static ReplicationMessageAck createBatchAck() {
        return new ReplicationMessageAck(5);
    }

    public ReplicationMessageAck() {
        super(0);
    }

    private ReplicationMessageAck(int type) {
        super(type);
        if (5 == type) {
            this.batch = new ArrayList<Tuple>();
        }
    }

    public void addAck(SyncReplicationActivity.ActivityID respondTo, ReplicationResultCode result) {
        Assert.assertTrue(5 == this.getType());
        Tuple tuple = new Tuple(respondTo, result);
        this.batch.add(tuple);
    }

    public List<Tuple> getBatch() {
        return this.batch;
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        if (5 == this.getType()) {
            int batchSize = in.readInt();
            Assert.assertTrue(batchSize > 0);
            this.batch = new ArrayList<Tuple>();
            for (int i = 0; i < batchSize; ++i) {
                SyncReplicationActivity.ActivityID respondTo = new SyncReplicationActivity.ActivityID(in.readLong());
                ReplicationResultCode result = ReplicationResultCode.decode(in.readInt());
                this.batch.add(new Tuple(respondTo, result));
            }
        }
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        if (5 == this.getType()) {
            int size = this.batch.size();
            Assert.assertTrue(size > 0);
            out.writeInt(size);
            for (Tuple tuple : this.batch) {
                out.writeLong(tuple.respondTo.id);
                out.writeInt(tuple.result.code());
            }
        }
    }

    public static class Tuple {
        public final SyncReplicationActivity.ActivityID respondTo;
        public final ReplicationResultCode result;

        public Tuple(SyncReplicationActivity.ActivityID respondTo, ReplicationResultCode result) {
            this.respondTo = respondTo;
            this.result = result;
        }
    }
}

