/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.dna.impl;

import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.object.EntityID;
import com.tc.object.LogicalOperation;
import com.tc.object.ObjectID;
import com.tc.object.dna.api.DNAEncodingInternal;
import com.tc.object.dna.api.DNAWriter;
import com.tc.object.dna.api.LogicalChangeID;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.tc.util.Assert;
import com.tc.util.Conversion;

public class DNAWriterImpl
implements DNAWriter {
    private static final int UNINITIALIZED = -1;
    private final TCByteBufferOutputStream output;
    private final TCByteBufferOutputStream.Mark headerMark;
    private final ObjectStringSerializer serializer;
    private final DNAEncodingInternal encoding;
    private byte flags = 0;
    private int firstLength = -1;
    private int totalLength = -1;
    private int lastStreamPos = -1;
    private int actionCount = 0;

    public DNAWriterImpl(TCByteBufferOutputStream output, EntityID id, ObjectStringSerializer serializer, DNAEncodingInternal encoding, boolean isDelta) {
        this(output, id, serializer, encoding, -1L, isDelta);
    }

    protected DNAWriterImpl(TCByteBufferOutputStream output, EntityID id, ObjectStringSerializer serializer, DNAEncodingInternal encoding, long version, boolean isDelta) {
        this.output = output;
        this.encoding = encoding;
        this.serializer = serializer;
        this.headerMark = output.mark();
        output.writeInt(-1);
        output.writeInt(-1);
        output.writeByte(this.flags);
        output.writeString(id.getClassName());
        output.writeString(id.getEntityName());
        this.flags = Conversion.setFlag(this.flags, 2, isDelta);
        if (version != -1L) {
            this.flags = Conversion.setFlag(this.flags, 4, true);
            output.writeLong(version);
        }
    }

    @Override
    public void setIgnoreMissing(boolean ignoreMissing) {
        this.flags = Conversion.setFlag(this.flags, 8, ignoreMissing);
    }

    @Override
    public void markSectionEnd() {
        if (this.lastStreamPos != -1) {
            throw new IllegalStateException("lastStreamPos=" + this.lastStreamPos);
        }
        if (this.totalLength != -1) {
            throw new IllegalStateException("totalLength=" + this.totalLength);
        }
        this.lastStreamPos = this.output.getBytesWritten();
        this.firstLength = this.totalLength = this.output.getBytesWritten() - this.headerMark.getPosition();
    }

    @Override
    public void addLogicalAction(LogicalOperation method, Object[] parameters, LogicalChangeID logicalChangeID) {
        ++this.actionCount;
        this.output.writeByte(1);
        this.output.writeBoolean(logicalChangeID.isNull());
        if (!logicalChangeID.isNull()) {
            this.output.writeLong(logicalChangeID.toLong());
        }
        this.output.writeInt(method.ordinal());
        this.output.writeByte(parameters.length);
        for (Object parameter : parameters) {
            this.encoding.encode(parameter, this.output, this.serializer);
        }
    }

    @Override
    public void addSubArrayAction(int start, Object array, int length) {
        ++this.actionCount;
        this.output.writeByte(7);
        this.output.writeInt(start);
        this.encoding.encodeArray(array, this.output, length);
    }

    @Override
    public void addPhysicalAction(String fieldName, Object value) {
        this.addPhysicalAction(fieldName, value, value instanceof ObjectID);
    }

    @Override
    public void addPhysicalAction(String fieldName, Object value, boolean canBeReferenced) {
        if (value == null) {
            value = ObjectID.NULL_ID;
            canBeReferenced = true;
        }
        ++this.actionCount;
        if (canBeReferenced) {
            this.output.writeByte(6);
        } else {
            this.output.writeByte(2);
        }
        this.serializer.writeFieldName(this.output, fieldName);
        this.encoding.encode(value, this.output);
    }

    @Override
    public void addArrayElementAction(int index, Object value) {
        ++this.actionCount;
        this.output.writeByte(3);
        this.output.writeInt(index);
        this.encoding.encode(value, this.output);
    }

    @Override
    public void addEntireArray(Object value) {
        ++this.actionCount;
        this.output.writeByte(4);
        this.encoding.encodeArray(value, this.output);
    }

    @Override
    public void addLiteralValue(Object value) {
        ++this.actionCount;
        this.output.writeByte(5);
        this.encoding.encode(value, this.output);
    }

    @Override
    public void finalizeHeader() {
        if (Conversion.getFlag(this.flags, 2) && this.actionCount == 0) {
            throw new AssertionError((Object)"sending delta DNA with no actions!");
        }
        byte[] lengths = new byte[9];
        Conversion.writeInt(this.totalLength, lengths, 0);
        Conversion.writeInt(this.actionCount, lengths, 4);
        lengths[8] = this.flags;
        this.headerMark.write(lengths);
    }

    @Override
    public void setArrayLength(int length) {
        this.checkVariableHeaderEmpty();
        this.flags = Conversion.setFlag(this.flags, 1, true);
        this.output.writeInt(length);
    }

    private void checkVariableHeaderEmpty() {
        Assert.assertEquals(0, this.actionCount);
        Assert.assertFalse(Conversion.getFlag(this.flags, 1));
    }

    @Override
    public int getActionCount() {
        return this.actionCount;
    }

    @Override
    public void copyTo(TCByteBufferOutput dest) {
        this.headerMark.copyTo(dest, this.firstLength);
    }

    @Override
    public void addLogicalAction(LogicalOperation method, Object[] parameters) {
        this.addLogicalAction(method, parameters, LogicalChangeID.NULL_ID);
    }
}

