/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import java.io.IOException;
import java.util.Map;

public abstract class MapSerializer<K, V>
implements TCSerializable<MapSerializer<K, V>> {
    private final Map<K, V> map;

    protected MapSerializer(Map<K, V> map) {
        this.map = map;
    }

    protected abstract void serializeKey(K var1, TCByteBufferOutput var2);

    protected abstract void serializeValue(V var1, TCByteBufferOutput var2);

    protected abstract K deserializeKey(TCByteBufferInput var1) throws IOException;

    protected abstract V deserializeValue(TCByteBufferInput var1) throws IOException;

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.writeInt(this.map.size());
        for (Map.Entry<K, V> kvEntry : this.map.entrySet()) {
            this.serializeKey(kvEntry.getKey(), serialOutput);
            this.serializeValue(kvEntry.getValue(), serialOutput);
        }
    }

    @Override
    public MapSerializer<K, V> deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        int size = serialInput.readInt();
        for (int i = 0; i < size; ++i) {
            this.map.put(this.deserializeKey(serialInput), this.deserializeValue(serialInput));
        }
        return this;
    }

    public Map<K, V> getMappings() {
        return this.map;
    }
}

