/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.config.builders;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.ehcache.clustered.client.config.ClusteringServiceConfiguration;
import org.ehcache.clustered.client.config.TimeoutDuration;
import org.ehcache.clustered.client.config.builders.ServerSideConfigurationBuilder;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.config.Builder;

public final class ClusteringServiceConfigurationBuilder
implements Builder<ClusteringServiceConfiguration> {
    private final URI clusterUri;
    private final TimeoutDuration readOperationTimeout;
    private final Boolean autoCreate;

    public static ClusteringServiceConfigurationBuilder cluster(URI clusterUri) {
        return new ClusteringServiceConfigurationBuilder(clusterUri);
    }

    private ClusteringServiceConfigurationBuilder(URI clusterUri) {
        this.clusterUri = clusterUri;
        this.readOperationTimeout = null;
        this.autoCreate = null;
    }

    private ClusteringServiceConfigurationBuilder(ClusteringServiceConfigurationBuilder original, TimeoutDuration readOperationTimeout) {
        this.clusterUri = original.clusterUri;
        this.readOperationTimeout = readOperationTimeout;
        this.autoCreate = original.autoCreate;
    }

    private ClusteringServiceConfigurationBuilder(ClusteringServiceConfigurationBuilder original, boolean autoCreate) {
        this.clusterUri = original.clusterUri;
        this.readOperationTimeout = original.readOperationTimeout;
        this.autoCreate = autoCreate;
    }

    public ServerSideConfigurationBuilder autoCreate() {
        return new ServerSideConfigurationBuilder(new ClusteringServiceConfigurationBuilder(this, true));
    }

    public ServerSideConfigurationBuilder expecting() {
        return new ServerSideConfigurationBuilder(new ClusteringServiceConfigurationBuilder(this, false));
    }

    public ClusteringServiceConfigurationBuilder readOperationTimeout(long duration, TimeUnit unit) {
        return new ClusteringServiceConfigurationBuilder(this, TimeoutDuration.of(duration, unit));
    }

    public ClusteringServiceConfiguration build() {
        if (this.readOperationTimeout == null) {
            return new ClusteringServiceConfiguration(this.clusterUri);
        }
        return new ClusteringServiceConfiguration(this.clusterUri, this.readOperationTimeout);
    }

    ClusteringServiceConfiguration build(ServerSideConfiguration serverSideConfiguration) {
        ClusteringServiceConfiguration configuration = this.autoCreate != null ? (this.readOperationTimeout != null ? new ClusteringServiceConfiguration(this.clusterUri, this.readOperationTimeout, this.autoCreate, serverSideConfiguration) : new ClusteringServiceConfiguration(this.clusterUri, this.autoCreate, serverSideConfiguration)) : (this.readOperationTimeout != null ? new ClusteringServiceConfiguration(this.clusterUri, this.readOperationTimeout, serverSideConfiguration) : new ClusteringServiceConfiguration(this.clusterUri, serverSideConfiguration));
        return configuration;
    }
}

