/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.management;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public final class ServiceID
implements TCSerializable<ServiceID> {
    private static final AtomicInteger ID_GEN = new AtomicInteger();
    private String className;
    private int id;

    public static ServiceID newServiceID(Object obj) {
        return new ServiceID(obj.getClass().getName(), ID_GEN.incrementAndGet());
    }

    public ServiceID() {
    }

    public ServiceID(String className, int id) {
        this.className = className;
        this.id = id;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServiceID) {
            ServiceID other = (ServiceID)obj;
            return other.className.equals(this.className) && other.id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.className.hashCode() + this.id;
    }

    public String toString() {
        return "ServiceID[" + this.className + ":" + this.id + "]";
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.writeInt(this.id);
        serialOutput.writeString(this.className);
    }

    @Override
    public ServiceID deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        this.id = serialInput.readInt();
        this.className = serialInput.readString();
        return this;
    }
}

