/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.ehcache.CachePersistenceException;
import org.ehcache.clustered.client.internal.ClusterTierManagerClientEntity;
import org.ehcache.clustered.client.internal.ClusterTierManagerCreationException;
import org.ehcache.clustered.client.internal.ClusterTierManagerNotFoundException;
import org.ehcache.clustered.client.internal.ClusterTierManagerValidationException;
import org.ehcache.clustered.client.internal.InternalClusterTierManagerClientEntity;
import org.ehcache.clustered.client.internal.Timeouts;
import org.ehcache.clustered.client.internal.lock.VoltronReadWriteLock;
import org.ehcache.clustered.client.internal.store.ClusterTierClientEntity;
import org.ehcache.clustered.client.internal.store.InternalClusterTierClientEntity;
import org.ehcache.clustered.client.service.EntityBusyException;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.ClusterTierManagerConfiguration;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.store.ClusterTierEntityConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityConfigurationException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.exception.PermanentEntityException;

public class ClusterTierManagerClientEntityFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterTierManagerClientEntityFactory.class);
    private final Connection connection;
    private final Map<String, VoltronReadWriteLock.Hold> maintenanceHolds = new ConcurrentHashMap<String, VoltronReadWriteLock.Hold>();
    private final Timeouts entityTimeouts;

    public ClusterTierManagerClientEntityFactory(Connection connection) {
        this(connection, Timeouts.builder().build());
    }

    public ClusterTierManagerClientEntityFactory(Connection connection, Timeouts entityTimeouts) {
        this.connection = connection;
        this.entityTimeouts = entityTimeouts;
    }

    public boolean acquireLeadership(String entityIdentifier) {
        VoltronReadWriteLock lock = this.createAccessLockFor(entityIdentifier);
        VoltronReadWriteLock.Hold hold = lock.tryWriteLock();
        if (hold == null) {
            return false;
        }
        this.maintenanceHolds.put(entityIdentifier, hold);
        return true;
    }

    public void abandonLeadership(String entityIdentifier) {
        VoltronReadWriteLock.Hold hold = this.maintenanceHolds.remove(entityIdentifier);
        if (hold == null) {
            throw new IllegalMonitorStateException("Leadership was never held");
        }
        hold.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(String identifier, ServerSideConfiguration config) throws EntityAlreadyExistsException, ClusterTierManagerCreationException, EntityBusyException, TimeoutException {
        VoltronReadWriteLock.Hold existingMaintenance = this.maintenanceHolds.get(identifier);
        VoltronReadWriteLock.Hold localMaintenance = null;
        if (existingMaintenance == null) {
            localMaintenance = this.createAccessLockFor(identifier).tryWriteLock();
        }
        if (existingMaintenance == null && localMaintenance == null) {
            throw new EntityBusyException("Unable to create clustered tier manager for id " + identifier + ": another client owns the maintenance lease");
        }
        boolean finished = false;
        try {
            EntityRef<InternalClusterTierManagerClientEntity, ClusterTierManagerConfiguration> ref = this.getEntityRef(identifier);
            while (true) {
                block23: {
                    InternalClusterTierManagerClientEntity entity;
                    block22: {
                        ref.create(new ClusterTierManagerConfiguration(identifier, config));
                        entity = ref.fetchEntity();
                        try {
                            entity.setTimeouts(this.entityTimeouts);
                            finished = true;
                            if (!finished) break block22;
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    if (finished) {
                                        entity.close();
                                    } else {
                                        this.silentlyClose(entity, identifier);
                                    }
                                    throw throwable;
                                }
                                catch (EntityNotFoundException e) {
                                }
                            }
                            catch (EntityConfigurationException e) {
                                throw new ClusterTierManagerCreationException("Unable to configure clustered tier manager for id " + identifier, e);
                            }
                            catch (EntityNotProvidedException e) {
                                LOGGER.error("Unable to create clustered tier manager for id {}", (Object)identifier, (Object)e);
                                throw new AssertionError((Object)e);
                            }
                            catch (EntityVersionMismatchException e) {
                                LOGGER.error("Unable to create clustered tier manager for id {}", (Object)identifier, (Object)e);
                                throw new AssertionError((Object)e);
                            }
                            continue;
                        }
                        entity.close();
                        break block23;
                    }
                    this.silentlyClose(entity, identifier);
                }
                return;
                break;
            }
        }
        finally {
            if (localMaintenance != null) {
                if (finished) {
                    localMaintenance.unlock();
                } else {
                    this.silentlyUnlock(localMaintenance, identifier);
                }
            }
        }
    }

    public ClusterTierManagerClientEntity retrieve(String identifier, ServerSideConfiguration config) throws EntityNotFoundException, ClusterTierManagerValidationException, TimeoutException {
        InternalClusterTierManagerClientEntity entity;
        VoltronReadWriteLock.Hold fetchHold = this.createAccessLockFor(identifier).readLock();
        try {
            entity = this.getEntityRef(identifier).fetchEntity();
        }
        catch (EntityVersionMismatchException e) {
            LOGGER.error("Unable to retrieve clustered tier manager for id {}", (Object)identifier, (Object)e);
            this.silentlyUnlock(fetchHold, identifier);
            throw new AssertionError((Object)e);
        }
        boolean validated = false;
        try {
            entity.setTimeouts(this.entityTimeouts);
            entity.validate(config);
            validated = true;
            InternalClusterTierManagerClientEntity internalClusterTierManagerClientEntity = entity;
            return internalClusterTierManagerClientEntity;
        }
        catch (ClusterException e) {
            throw new ClusterTierManagerValidationException("Unable to validate clustered tier manager for id " + identifier, e);
        }
        finally {
            if (!validated) {
                this.silentlyClose(entity, identifier);
                this.silentlyUnlock(fetchHold, identifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(String identifier) throws ClusterTierManagerNotFoundException, EntityBusyException, CachePersistenceException {
        VoltronReadWriteLock.Hold existingMaintenance = this.maintenanceHolds.get(identifier);
        VoltronReadWriteLock.Hold localMaintenance = null;
        if (existingMaintenance == null) {
            localMaintenance = this.createAccessLockFor(identifier).tryWriteLock();
        }
        if (existingMaintenance == null && localMaintenance == null) {
            throw new EntityBusyException("Destroy operation failed; " + identifier + " clustered tier's maintenance lease held");
        }
        boolean finished = false;
        try {
            EntityRef<InternalClusterTierManagerClientEntity, ClusterTierManagerConfiguration> ref = this.getEntityRef(identifier);
            this.destroyAllClusterTiers(ref, identifier);
            try {
                if (!ref.destroy()) {
                    throw new EntityBusyException("Destroy operation failed; " + identifier + " clustered tier in use by other clients");
                }
                finished = true;
            }
            catch (EntityNotProvidedException e) {
                LOGGER.error("Unable to delete clustered tier manager for id {}", (Object)identifier, (Object)e);
                throw new AssertionError((Object)e);
            }
            catch (EntityNotFoundException e) {
                throw new ClusterTierManagerNotFoundException(e);
            }
            catch (PermanentEntityException e) {
                LOGGER.error("Unable to destroy entity - server says it is permanent", (Throwable)e);
                throw new AssertionError((Object)e);
            }
        }
        finally {
            if (localMaintenance != null) {
                if (finished) {
                    localMaintenance.unlock();
                } else {
                    this.silentlyUnlock(localMaintenance, identifier);
                }
            }
        }
    }

    private void destroyAllClusterTiers(EntityRef<InternalClusterTierManagerClientEntity, ClusterTierManagerConfiguration> ref, String identifier) throws ClusterTierManagerNotFoundException, CachePersistenceException {
        ClusterTierManagerClientEntity entity;
        try {
            entity = ref.fetchEntity();
            try {
                entity.validate(null);
            }
            catch (ClusterException e) {
                throw new ClusterTierManagerNotFoundException("Existing entity configuration does not match provided one", e);
            }
            catch (TimeoutException e) {
            }
        }
        catch (EntityNotFoundException e) {
            return;
        }
        catch (EntityVersionMismatchException e) {
            throw new AssertionError((Object)e);
        }
        Set<String> storeIdentifiers = entity.prepareForDestroy();
        LOGGER.warn("Preparing to destroy stores {}", storeIdentifiers);
        for (String storeIdentifier : storeIdentifiers) {
            try {
                this.destroyClusteredStoreEntity(identifier, storeIdentifier);
            }
            catch (EntityNotFoundException e) {}
        }
        entity.close();
    }

    private void silentlyClose(ClusterTierManagerClientEntity entity, String identifier) {
        try {
            entity.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to close entity {}", (Object)identifier, (Object)e);
        }
    }

    private void silentlyUnlock(VoltronReadWriteLock.Hold localMaintenance, String identifier) {
        try {
            localMaintenance.unlock();
        }
        catch (Exception e) {
            LOGGER.error("Failed to unlock for id {}", (Object)identifier, (Object)e);
        }
    }

    private VoltronReadWriteLock createAccessLockFor(String entityIdentifier) {
        return new VoltronReadWriteLock(this.connection, "ClusterTierManagerClientEntityFactory-AccessLock-" + entityIdentifier);
    }

    private EntityRef<InternalClusterTierManagerClientEntity, ClusterTierManagerConfiguration> getEntityRef(String identifier) {
        try {
            return this.connection.getEntityRef(InternalClusterTierManagerClientEntity.class, 10L, identifier);
        }
        catch (EntityNotProvidedException e) {
            LOGGER.error("Unable to get clustered tier manager for id {}", (Object)identifier, (Object)e);
            throw new AssertionError((Object)e);
        }
    }

    public ClusterTierClientEntity fetchOrCreateClusteredStoreEntity(UUID clientId, String clusterTierManagerIdentifier, String storeIdentifier, ServerStoreConfiguration clientStoreConfiguration, boolean autoCreate) throws EntityNotFoundException, CachePersistenceException {
        EntityRef<InternalClusterTierClientEntity, ClusterTierEntityConfiguration> entityRef;
        try {
            entityRef = this.connection.getEntityRef(InternalClusterTierClientEntity.class, 10L, ClusterTierManagerClientEntityFactory.entityName(clusterTierManagerIdentifier, storeIdentifier));
        }
        catch (EntityNotProvidedException e) {
            throw new AssertionError((Object)e);
        }
        if (autoCreate) {
            while (true) {
                try {
                    entityRef.create(new ClusterTierEntityConfiguration(clusterTierManagerIdentifier, storeIdentifier, clientStoreConfiguration));
                }
                catch (EntityAlreadyExistsException e) {
                }
                catch (EntityConfigurationException e) {
                    throw new CachePersistenceException("Unable to create clustered tier", (Throwable)e);
                }
                catch (EntityException e) {
                    throw new AssertionError((Object)e);
                }
                try {
                    InternalClusterTierClientEntity entity = entityRef.fetchEntity();
                    entity.setClientId(clientId);
                    entity.setStoreIdentifier(storeIdentifier);
                    entity.setTimeouts(this.entityTimeouts);
                    return entity;
                }
                catch (EntityNotFoundException e) {
                    continue;
                }
                catch (EntityException e) {
                    throw new AssertionError((Object)e);
                }
                break;
            }
        }
        try {
            InternalClusterTierClientEntity entity = entityRef.fetchEntity();
            entity.setClientId(clientId);
            entity.setStoreIdentifier(storeIdentifier);
            entity.setTimeouts(this.entityTimeouts);
            return entity;
        }
        catch (EntityNotFoundException e) {
            throw e;
        }
        catch (EntityException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void destroyClusteredStoreEntity(String clusterTierManagerIdentifier, String storeIdentifier) throws EntityNotFoundException, CachePersistenceException {
        try {
            EntityRef entityRef = this.connection.getEntityRef(InternalClusterTierClientEntity.class, 10L, ClusterTierManagerClientEntityFactory.entityName(clusterTierManagerIdentifier, storeIdentifier));
            if (!entityRef.destroy()) {
                throw new CachePersistenceException("Cannot destroy clustered tier '" + storeIdentifier + "': in use by other client(s)");
            }
        }
        catch (EntityNotProvidedException e) {
            throw new AssertionError((Object)e);
        }
        catch (PermanentEntityException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String entityName(String clusterTierManagerIdentifier, String storeIdentifier) {
        return clusterTierManagerIdentifier + "$" + storeIdentifier;
    }
}

