/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.net.protocol.transport.ConnectionIDFactoryListener;
import com.tc.util.Assert;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class NullConnectionIDFactoryImpl
implements ConnectionIDFactory {
    private final AtomicLong cid = new AtomicLong(-2L);

    @Override
    public long getCurrentConnectionID() {
        return this.cid.get();
    }

    @Override
    public ConnectionID populateConnectionID(ConnectionID connectionID) {
        ConnectionID connection = new ConnectionID(connectionID.getJvmID(), this.cid.decrementAndGet());
        Assert.assertTrue(!connection.isValid());
        return connection;
    }

    @Override
    public void restoreConnectionId(ConnectionID rv) {
    }

    @Override
    public Set<ConnectionID> loadConnectionIDs() {
        return Collections.emptySet();
    }

    @Override
    public void registerForConnectionIDEvents(ConnectionIDFactoryListener listener) {
    }

    @Override
    public void init(String clusterID, long nextAvailChannelID, Set<ConnectionID> connections) {
    }
}

