/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.ClusteredTierManagerConfiguration;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.messages.ConfigCodec;
import org.ehcache.clustered.common.internal.store.ClusteredTierEntityConfiguration;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructEncoder;

public class EntityConfigurationCodec {
    private static final String IDENTIFIER = "identifier";
    private final StructBuilder tierManagerConfigurationBaseStruct = StructBuilder.newStructBuilder().string("identifier", 10);
    private final StructBuilder clusteredStoreConfigurationBaseStruct = StructBuilder.newStructBuilder().string("identifier", 10).string("serverStoreName", 20);
    private final ConfigCodec configCodec;
    private final Struct tierManagerConfigurationStruct;
    private final Struct clusteredStoreConfigurationStruct;

    public EntityConfigurationCodec(ConfigCodec configCodec) {
        this.configCodec = configCodec;
        this.tierManagerConfigurationStruct = configCodec.injectServerSideConfiguration(this.tierManagerConfigurationBaseStruct, 10).getUpdatedBuilder().build();
        this.clusteredStoreConfigurationStruct = configCodec.injectServerStoreConfiguration(this.clusteredStoreConfigurationBaseStruct, 30).getUpdatedBuilder().build();
    }

    public byte[] encode(ClusteredTierEntityConfiguration configuration) {
        StructEncoder<Void> encoder = this.clusteredStoreConfigurationStruct.encoder();
        ((StructEncoder)encoder.string(IDENTIFIER, configuration.getManagerIdentifier())).string("serverStoreName", configuration.getStoreIdentifier());
        this.configCodec.encodeServerStoreConfiguration(encoder, configuration.getConfiguration());
        return encoder.encode().array();
    }

    public ClusteredTierEntityConfiguration decodeClusteredStoreConfiguration(byte[] configuration) {
        StructDecoder<Void> decoder = this.clusteredStoreConfigurationStruct.decoder(ByteBuffer.wrap(configuration));
        String managerIdentifier = decoder.string(IDENTIFIER);
        if (managerIdentifier == null) {
            throw new IllegalArgumentException("Payload is an invalid content");
        }
        String storeIdentifier = decoder.string("serverStoreName");
        ServerStoreConfiguration serverStoreConfiguration = this.configCodec.decodeServerStoreConfiguration(decoder);
        return new ClusteredTierEntityConfiguration(managerIdentifier, storeIdentifier, serverStoreConfiguration);
    }

    public byte[] encode(ClusteredTierManagerConfiguration configuration) {
        StructEncoder<Void> encoder = this.tierManagerConfigurationStruct.encoder();
        encoder.string(IDENTIFIER, configuration.getIdentifier());
        this.configCodec.encodeServerSideConfiguration(encoder, configuration.getConfiguration());
        return encoder.encode().array();
    }

    public ClusteredTierManagerConfiguration decodeClusteredTierManagerConfiguration(byte[] payload) {
        StructDecoder<Void> decoder = this.tierManagerConfigurationStruct.decoder(ByteBuffer.wrap(payload));
        String identifier = decoder.string(IDENTIFIER);
        if (identifier == null) {
            throw new IllegalArgumentException("Payload is an invalid content");
        }
        ServerSideConfiguration configuration = this.configCodec.decodeServerSideConfiguration(decoder);
        if (configuration == null) {
            throw new AssertionError((Object)"Creation configuration cannot be null");
        }
        return new ClusteredTierManagerConfiguration(identifier, configuration);
    }
}

