/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.bytes.TCByteBuffer;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageFactory;
import com.tc.net.protocol.tcm.TCMessageHeaderImpl;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.util.Assert;

class TCMessageParser {
    private static final TCLogger logger = TCLogging.getLogger(TCMessageParser.class);
    private final TCMessageFactory factory;

    TCMessageParser(TCMessageFactory factory) {
        this.factory = factory;
    }

    TCMessage parseMessage(MessageChannel source, TCByteBuffer[] data) {
        TCByteBuffer[] msgData;
        TCMessageHeaderImpl hdr = new TCMessageHeaderImpl(data[0].duplicate().limit(8));
        int headerLength = hdr.getHeaderByteLength();
        if (headerLength != 8) {
            logger.error("Invalid header length ! length = " + headerLength);
            logger.error("error header = " + hdr);
            logger.error(" buffer data is " + this.toString(data));
            throw new RuntimeException("Invalid header length: " + headerLength);
        }
        if (data[0].limit() > headerLength) {
            msgData = new TCByteBuffer[data.length];
            System.arraycopy(data, 0, msgData, 0, msgData.length);
            msgData[0] = msgData[0].position(headerLength).slice();
        } else {
            Assert.eval(data.length > 1);
            msgData = new TCByteBuffer[data.length - 1];
            System.arraycopy(data, 1, msgData, 0, msgData.length);
        }
        int msgType = hdr.getMessageType();
        TCMessageType type = TCMessageType.getInstance(hdr.getMessageType());
        if (type == null) {
            throw new RuntimeException("Can't find message type for type: " + msgType);
        }
        return this.factory.createMessage(source, type, hdr, msgData);
    }

    private String toString(TCByteBuffer[] data) {
        if (data == null || data.length == 0) {
            return "null or size 0";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            sb.append(data[i]);
            sb.append(" { ");
            byte[] b = data[i].array();
            for (int j = 0; j < b.length; ++j) {
                sb.append(b[j]).append(" ");
            }
            sb.append(" } ");
        }
        return sb.toString();
    }
}

