/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal;

import java.util.UUID;

public final class ClusteredEhcacheIdentity {
    private ClusteredEhcacheIdentity() {
    }

    public static byte[] serialize(UUID identity) {
        long msb = identity.getMostSignificantBits();
        long lsb = identity.getLeastSignificantBits();
        byte[] bytes = new byte[16];
        ClusteredEhcacheIdentity.putLong(bytes, 0, msb);
        ClusteredEhcacheIdentity.putLong(bytes, 8, lsb);
        return bytes;
    }

    public static UUID deserialize(byte[] bytes) {
        if (bytes.length != 16) {
            throw new IllegalArgumentException("Expected a 16 byte (UUID) config stream");
        }
        long msb = ClusteredEhcacheIdentity.getLong(bytes, 0);
        long lsb = ClusteredEhcacheIdentity.getLong(bytes, 8);
        return new UUID(msb, lsb);
    }

    private static void putLong(byte[] array, int offset, long value) {
        if (offset < 0 || array.length < offset + 8) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = 7; i >= 0; --i) {
            array[offset + i] = (byte)value;
            value >>= 8;
        }
    }

    private static long getLong(byte[] array, int offset) {
        if (offset < 0 || array.length < offset + 8) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(array[offset + i] & 0xFF);
        }
        return result;
    }
}

