/*
 * Decompiled with CFR 0.152.
 */
package com.tc.stats.counter;

import com.tc.stats.counter.CounterImpl;

public class BoundedCounter
extends CounterImpl {
    private final long minBound;
    private final long maxBound;

    public BoundedCounter() {
        this(0L);
    }

    public BoundedCounter(long initialValue) {
        this(initialValue, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public BoundedCounter(long initialValue, long minValue, long maxValue) {
        super(initialValue);
        this.minBound = Math.min(minValue, maxValue);
        this.maxBound = Math.max(minValue, maxValue);
        if (initialValue < this.minBound) {
            super.setValue(this.minBound);
        } else if (initialValue > this.maxBound) {
            super.setValue(this.maxBound);
        }
    }

    @Override
    public synchronized long decrement() {
        long current = this.getValue();
        if (current <= this.minBound) {
            return current;
        }
        return super.decrement();
    }

    @Override
    public synchronized long decrement(long amount) {
        long current = this.getValue();
        if (current - amount <= this.minBound) {
            super.setValue(this.minBound);
            return this.minBound;
        }
        return super.decrement(amount);
    }

    @Override
    public synchronized long getAndSet(long newValue) {
        if (newValue < this.minBound) {
            newValue = this.minBound;
        } else if (newValue > this.maxBound) {
            newValue = this.maxBound;
        }
        return super.getAndSet(newValue);
    }

    @Override
    public synchronized long increment() {
        long current = this.getValue();
        if (current >= this.maxBound) {
            return current;
        }
        return super.increment();
    }

    @Override
    public synchronized long increment(long amount) {
        long current = this.getValue();
        if (current + amount >= this.maxBound) {
            super.setValue(this.maxBound);
            return this.maxBound;
        }
        return super.increment(amount);
    }

    @Override
    public synchronized void setValue(long newValue) {
        if (newValue < this.minBound) {
            newValue = this.minBound;
        } else if (newValue > this.maxBound) {
            newValue = this.maxBound;
        }
        super.setValue(newValue);
    }
}

