/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.connection;

import java.net.URI;
import java.util.Properties;
import java.util.ServiceLoader;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionService;

public final class ConnectionFactory {
    public static Connection connect(URI uri, Properties properties) throws ConnectionException {
        ServiceLoader<ConnectionService> serviceLoader = ServiceLoader.load(ConnectionService.class, ConnectionFactory.class.getClassLoader());
        for (ConnectionService connectionService : serviceLoader) {
            if (!connectionService.handlesURI(uri)) continue;
            return connectionService.connect(uri, properties);
        }
        throw new IllegalArgumentException("Unknown URI " + uri);
    }
}

