/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

import com.tc.net.ClientID;
import com.tc.object.locks.ServerLockContextStateMachine;
import com.tc.object.locks.ServerLockLevel;
import com.tc.object.locks.ThreadID;
import com.tc.util.SinglyLinkedList;

public abstract class ServerLockContext
implements SinglyLinkedList.LinkedNode<ServerLockContext> {
    private State state;
    private final ClientID clientID;
    private ThreadID threadID;

    public ServerLockContext(ClientID clientID, ThreadID threadID) {
        this.clientID = clientID;
        this.threadID = threadID;
    }

    public final void setThreadID(ThreadID threadID) {
        this.threadID = threadID;
    }

    public final void setState(ServerLockContextStateMachine machine, State newState) {
        if (!machine.canSetState(this.state, newState)) {
            throw new IllegalStateException("Old=" + (Object)((Object)this.state) + " to " + (Object)((Object)newState));
        }
        this.state = newState;
    }

    public final ThreadID getThreadID() {
        return this.threadID;
    }

    public final ClientID getClientID() {
        return this.clientID;
    }

    public final State getState() {
        return this.state;
    }

    public boolean isWaiter() {
        return this.state.getType() == Type.WAITER;
    }

    public boolean isPending() {
        return this.state.getType() == Type.PENDING || this.state.getType() == Type.TRY_PENDING;
    }

    public boolean isTryPending() {
        return this.state.getType() == Type.TRY_PENDING;
    }

    public boolean isHolder() {
        return this.state.getType() == Type.GREEDY_HOLDER || this.state.getType() == Type.HOLDER;
    }

    public boolean isGreedyHolder() {
        return this.state.getType() == Type.GREEDY_HOLDER;
    }

    public String toString() {
        return "ServerLockContext [clientID=" + this.clientID + ", state=" + (Object)((Object)this.state) + ", threadID=" + this.threadID + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clientID == null ? 0 : this.clientID.hashCode());
        result = 31 * result + (this.threadID == null ? 0 : this.threadID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerLockContext)) {
            return false;
        }
        ServerLockContext other = (ServerLockContext)obj;
        if (!this.clientID.equals(other.clientID)) {
            return false;
        }
        return this.threadID.equals(other.threadID);
    }

    public static enum State {
        GREEDY_HOLDER_READ(ServerLockLevel.READ, Type.GREEDY_HOLDER),
        GREEDY_HOLDER_WRITE(ServerLockLevel.WRITE, Type.GREEDY_HOLDER),
        HOLDER_READ(ServerLockLevel.READ, Type.HOLDER),
        HOLDER_WRITE(ServerLockLevel.WRITE, Type.HOLDER),
        WAITER(ServerLockLevel.WRITE, Type.WAITER),
        TRY_PENDING_READ(ServerLockLevel.READ, Type.TRY_PENDING),
        TRY_PENDING_WRITE(ServerLockLevel.WRITE, Type.TRY_PENDING),
        PENDING_READ(ServerLockLevel.READ, Type.PENDING),
        PENDING_WRITE(ServerLockLevel.WRITE, Type.PENDING);

        private ServerLockLevel level;
        private Type type;

        private State(ServerLockLevel level, Type type) {
            this.level = level;
            this.type = type;
        }

        public ServerLockLevel getLockLevel() {
            return this.level;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return (Object)((Object)this.type) + ":" + (Object)((Object)this.level);
        }
    }

    public static enum Type {
        GREEDY_HOLDER,
        HOLDER,
        TRY_PENDING,
        WAITER,
        PENDING;

    }
}

