/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.groups;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.net.GroupID;
import com.tc.net.StripeID;
import com.tc.net.groups.NodeIDSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class GroupToStripeMapSerializer
implements TCSerializable<GroupToStripeMapSerializer> {
    private final Map<GroupID, StripeID> groupToStripeMap;

    public GroupToStripeMapSerializer() {
        this.groupToStripeMap = new HashMap<GroupID, StripeID>();
    }

    public GroupToStripeMapSerializer(Map<GroupID, StripeID> groupToStripeMap) {
        this.groupToStripeMap = groupToStripeMap;
    }

    public Map<GroupID, StripeID> getMap() {
        return this.groupToStripeMap;
    }

    @Override
    public GroupToStripeMapSerializer deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        int size = serialInput.readInt();
        for (int i = 0; i < size; ++i) {
            NodeIDSerializer nodeIDSerializer = new NodeIDSerializer();
            nodeIDSerializer.deserializeFrom(serialInput);
            GroupID gid = (GroupID)nodeIDSerializer.getNodeID();
            nodeIDSerializer = new NodeIDSerializer();
            nodeIDSerializer.deserializeFrom(serialInput);
            StripeID stripeID = (StripeID)nodeIDSerializer.getNodeID();
            this.groupToStripeMap.put(gid, stripeID);
        }
        return this;
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.writeInt(this.groupToStripeMap.size());
        for (Map.Entry<GroupID, StripeID> entry : this.groupToStripeMap.entrySet()) {
            new NodeIDSerializer(entry.getKey()).serializeTo(serialOutput);
            new NodeIDSerializer(entry.getValue()).serializeTo(serialOutput);
        }
    }
}

