/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.metadata;

import org.terracotta.runnel.decoding.ArrayDecoder;
import org.terracotta.runnel.decoding.StructArrayDecoder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.decoding.fields.ArrayField;
import org.terracotta.runnel.decoding.fields.Field;
import org.terracotta.runnel.decoding.fields.StructField;
import org.terracotta.runnel.decoding.fields.ValueField;
import org.terracotta.runnel.metadata.Metadata;
import org.terracotta.runnel.utils.ReadBuffer;

public class FieldDecoder {
    private final Metadata metadata;
    private ReadBuffer readBuffer;
    private int lastIndex = -1;
    private int readAheadIndex = -1;

    FieldDecoder(Metadata metadata, ReadBuffer readBuffer) {
        this.metadata = metadata;
        this.readBuffer = readBuffer;
    }

    public StructArrayDecoder decodeStructArray(String name, StructDecoder parent) {
        ArrayField field = this.nextField(name, ArrayField.class, StructField.class);
        if (field == null) {
            return null;
        }
        return new StructArrayDecoder((StructField)field.subField(), this.readBuffer, parent);
    }

    public StructDecoder decodeStruct(String name, StructDecoder parent) {
        StructField field = this.nextField(name, StructField.class, null);
        if (field == null) {
            return null;
        }
        return new StructDecoder(field, this.readBuffer, parent);
    }

    public <T> ArrayDecoder<T> decodeValueArray(String name, Class<? extends ValueField<T>> clazz, StructDecoder parent) {
        ArrayField field = this.nextField(name, ArrayField.class, clazz);
        if (field == null) {
            return null;
        }
        return new ArrayDecoder((ValueField)field.subField(), this.readBuffer, parent);
    }

    public <T> T decodeValue(String name, Class<? extends ValueField<T>> clazz) {
        ValueField<T> field = this.nextField(name, clazz, null);
        if (field == null) {
            return null;
        }
        return field.decode(this.readBuffer);
    }

    public void reset(ReadBuffer readBuffer) {
        this.lastIndex = -1;
        this.readBuffer = readBuffer;
    }

    private <T extends Field, S extends Field> T nextField(String name, Class<T> fieldClazz, Class<S> subFieldClazz) {
        Field field = this.findFieldWithIndex(name, fieldClazz, subFieldClazz);
        if (this.readBuffer.limitReached()) {
            return null;
        }
        int index = this.readAheadIndex > 0 ? this.readAheadIndex : this.readBuffer.getVlqInt();
        this.readAheadIndex = -1;
        while (index < field.index()) {
            int fieldSize = this.readBuffer.getVlqInt();
            this.readBuffer.skip(fieldSize);
            if (this.readBuffer.limitReached()) {
                return null;
            }
            index = this.readBuffer.getVlqInt();
        }
        if (index > field.index()) {
            this.readAheadIndex = index;
            return null;
        }
        if (index != field.index()) {
            return null;
        }
        return (T)field;
    }

    private <T extends Field, S extends Field> Field findFieldWithIndex(String name, Class<T> fieldClazz, Class<S> subFieldClazz) {
        ArrayField arrayField;
        Field nextSubField;
        Field field = this.metadata.getFieldByName(name);
        if (field == null) {
            throw new IllegalArgumentException("No such field : " + name);
        }
        if (field.index() <= this.lastIndex) {
            throw new IllegalArgumentException("No such field left : '" + name + "'");
        }
        this.lastIndex = field.index();
        if (field.getClass() != fieldClazz) {
            throw new IllegalArgumentException("Invalid type for field '" + name + "', expected : '" + fieldClazz.getSimpleName() + "' but was '" + field.getClass().getSimpleName() + "'");
        }
        if (subFieldClazz != null && !(nextSubField = (arrayField = (ArrayField)field).subField()).getClass().equals(subFieldClazz)) {
            throw new IllegalArgumentException("Invalid subtype for field '" + name + "', expected : '" + subFieldClazz.getSimpleName() + "' but was '" + nextSubField.getClass().getSimpleName() + "'");
        }
        return field;
    }
}

