/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.decoding;

import java.nio.ByteBuffer;
import org.terracotta.runnel.decoding.Enm;
import org.terracotta.runnel.decoding.PrimitiveDecodingSupport;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.decoding.fields.BoolField;
import org.terracotta.runnel.decoding.fields.ByteBufferField;
import org.terracotta.runnel.decoding.fields.CharField;
import org.terracotta.runnel.decoding.fields.EnumField;
import org.terracotta.runnel.decoding.fields.FloatingPoint64Field;
import org.terracotta.runnel.decoding.fields.Int32Field;
import org.terracotta.runnel.decoding.fields.Int64Field;
import org.terracotta.runnel.decoding.fields.StringField;
import org.terracotta.runnel.decoding.fields.StructField;
import org.terracotta.runnel.metadata.FieldDecoder;
import org.terracotta.runnel.utils.ReadBuffer;

public class StructArrayDecoder
implements PrimitiveDecodingSupport {
    private final FieldDecoder fieldDecoder;
    private final StructDecoder parent;
    private final ReadBuffer arrayReadBuffer;
    private final int arrayLength;
    private ReadBuffer structReadBuffer;

    public StructArrayDecoder(StructField field, ReadBuffer readBuffer, StructDecoder parent) {
        this.parent = parent;
        int arraySize = readBuffer.getVlqInt();
        this.arrayReadBuffer = readBuffer.limit(arraySize);
        this.arrayLength = readBuffer.getVlqInt();
        if (this.arrayLength > 0) {
            int structSize = readBuffer.getVlqInt();
            this.structReadBuffer = this.arrayReadBuffer.limit(structSize);
        } else {
            this.structReadBuffer = this.arrayReadBuffer.limit(0);
        }
        this.fieldDecoder = field.getMetadata().fieldDecoder(this.structReadBuffer);
    }

    @Override
    public Boolean bool(String name) {
        return (Boolean)this.fieldDecoder.decodeValue(name, BoolField.class);
    }

    @Override
    public Character chr(String name) {
        return (Character)this.fieldDecoder.decodeValue(name, CharField.class);
    }

    @Override
    public Integer int32(String name) {
        return (Integer)this.fieldDecoder.decodeValue(name, Int32Field.class);
    }

    @Override
    public <E> Enm<E> enm(String name) {
        Enm enm = (Enm)this.fieldDecoder.decodeValue(name, EnumField.class);
        if (enm == null) {
            return new Enm(name);
        }
        return enm;
    }

    @Override
    public Long int64(String name) {
        return (Long)this.fieldDecoder.decodeValue(name, Int64Field.class);
    }

    @Override
    public Double fp64(String name) {
        return (Double)this.fieldDecoder.decodeValue(name, FloatingPoint64Field.class);
    }

    @Override
    public String string(String name) {
        return (String)this.fieldDecoder.decodeValue(name, StringField.class);
    }

    @Override
    public ByteBuffer byteBuffer(String name) {
        return (ByteBuffer)this.fieldDecoder.decodeValue(name, ByteBufferField.class);
    }

    public int length() {
        return this.arrayLength;
    }

    public StructDecoder end() {
        this.arrayReadBuffer.skipAll();
        return this.parent;
    }

    public void next() {
        this.structReadBuffer.skipAll();
        if (this.arrayReadBuffer.limitReached()) {
            return;
        }
        int structSize = this.arrayReadBuffer.getVlqInt();
        this.structReadBuffer = this.arrayReadBuffer.limit(structSize);
        this.fieldDecoder.reset(this.structReadBuffer);
    }
}

