/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.io.Serializable;
import java.util.UUID;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;

public abstract class StateRepositoryOpMessage
extends EhcacheOperationMessage
implements Serializable {
    private final String cacheId;
    private final String mapId;
    private UUID clientId;
    protected long id = -1L;

    private StateRepositoryOpMessage(String cacheId, String mapId, UUID clientId) {
        this.cacheId = cacheId;
        this.mapId = mapId;
        this.clientId = clientId;
    }

    @Override
    public UUID getClientId() {
        if (this.clientId == null) {
            throw new AssertionError((Object)"Client Id cannot be null for StateRepository messages");
        }
        return this.clientId;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public String getMapId() {
        return this.mapId;
    }

    @Override
    public EhcacheEntityMessage.Type getType() {
        return EhcacheEntityMessage.Type.STATE_REPO_OP;
    }

    public abstract StateRepositoryOp operation();

    @Override
    public byte getOpCode() {
        return this.getType().getCode();
    }

    public static class EntrySetMessage
    extends StateRepositoryOpMessage {
        public EntrySetMessage(String cacheId, String mapId, UUID clientId) {
            super(cacheId, mapId, clientId);
        }

        @Override
        public StateRepositoryOp operation() {
            return StateRepositoryOp.ENTRY_SET;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.ENTRY_SET;
        }
    }

    public static class PutIfAbsentMessage
    extends KeyBasedMessage {
        private final Object value;

        public PutIfAbsentMessage(String cacheId, String mapId, Object key, Object value, UUID clientId) {
            super(cacheId, mapId, key, clientId);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public StateRepositoryOp operation() {
            return StateRepositoryOp.PUT_IF_ABSENT;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.PUT_IF_ABSENT;
        }
    }

    public static class GetMessage
    extends KeyBasedMessage {
        public GetMessage(String cacheId, String mapId, Object key, UUID clientId) {
            super(cacheId, mapId, key, clientId);
        }

        @Override
        public StateRepositoryOp operation() {
            return StateRepositoryOp.GET;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.GET_STATE_REPO;
        }
    }

    private static abstract class KeyBasedMessage
    extends StateRepositoryOpMessage {
        private final Object key;

        private KeyBasedMessage(String cacheId, String mapId, Object key, UUID clientId) {
            super(cacheId, mapId, clientId);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }

    public static enum StateRepositoryOp {
        GET,
        PUT_IF_ABSENT,
        ENTRY_SET;

    }
}

