/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.util.UUID;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.messages.ConcurrentEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.common.internal.messages.LifecycleMessage;
import org.ehcache.clustered.common.internal.store.Chain;

public abstract class PassiveReplicationMessage
extends EhcacheOperationMessage {
    @Override
    public EhcacheEntityMessage.Type getType() {
        return EhcacheEntityMessage.Type.REPLICATION_OP;
    }

    @Override
    public byte getOpCode() {
        return this.operation().getReplicationOpCode();
    }

    @Override
    public void setId(long id) {
        throw new UnsupportedOperationException("This method is not supported on replication message");
    }

    public abstract ReplicationOp operation();

    public static class DestroyServerStoreReplicationMessage
    extends ClientIDTrackerMessage {
        private final String storeName;

        public DestroyServerStoreReplicationMessage(LifecycleMessage.DestroyServerStore destroyMessage) {
            this(destroyMessage.getId(), destroyMessage.getClientId(), destroyMessage.getName());
        }

        public DestroyServerStoreReplicationMessage(long msgId, UUID clientId, String storeName) {
            super(msgId, clientId);
            this.storeName = storeName;
        }

        public String getStoreName() {
            return this.storeName;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.DESTROY_SERVER_STORE_REPLICATION;
        }
    }

    public static class CreateServerStoreReplicationMessage
    extends ClientIDTrackerMessage {
        private final String storeName;
        private final ServerStoreConfiguration storeConfiguration;

        public CreateServerStoreReplicationMessage(LifecycleMessage.CreateServerStore createMessage) {
            this(createMessage.getId(), createMessage.getClientId(), createMessage.getName(), createMessage.getStoreConfiguration());
        }

        public CreateServerStoreReplicationMessage(long msgId, UUID clientId, String storeName, ServerStoreConfiguration configuration) {
            super(msgId, clientId);
            this.storeName = storeName;
            this.storeConfiguration = configuration;
        }

        public String getStoreName() {
            return this.storeName;
        }

        public ServerStoreConfiguration getStoreConfiguration() {
            return this.storeConfiguration;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CREATE_SERVER_STORE_REPLICATION;
        }
    }

    public static class InvalidationCompleteMessage
    extends ClearInvalidationCompleteMessage {
        private final long key;

        public InvalidationCompleteMessage(String cacheId, long key) {
            super(cacheId);
            this.key = key;
        }

        @Override
        public long concurrencyKey() {
            return (long)this.getCacheId().hashCode() + this.key;
        }

        @Override
        public ReplicationOp operation() {
            return ReplicationOp.INVALIDATION_COMPLETE;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.INVALIDATION_COMPLETE;
        }

        public long getKey() {
            return this.key;
        }
    }

    public static class ClearInvalidationCompleteMessage
    extends PassiveReplicationMessage
    implements ConcurrentEntityMessage {
        private final String cacheId;

        public ClearInvalidationCompleteMessage(String cacheId) {
            this.cacheId = cacheId;
        }

        @Override
        public long concurrencyKey() {
            return this.cacheId.hashCode();
        }

        @Override
        public long getId() {
            throw new UnsupportedOperationException("Not supported for ClearInvalidationCompleteMessage");
        }

        @Override
        public UUID getClientId() {
            throw new UnsupportedOperationException("Not supported for ClearInvalidationCompleteMessage");
        }

        @Override
        public ReplicationOp operation() {
            return ReplicationOp.CLEAR_INVALIDATION_COMPLETE;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CLEAR_INVALIDATION_COMPLETE;
        }

        public String getCacheId() {
            return this.cacheId;
        }
    }

    public static class ChainReplicationMessage
    extends ClientIDTrackerMessage
    implements ConcurrentEntityMessage {
        private final String cacheId;
        private final long key;
        private final Chain chain;

        public ChainReplicationMessage(String cacheId, long key, Chain chain, long msgId, UUID clientId) {
            super(msgId, clientId);
            this.cacheId = cacheId;
            this.key = key;
            this.chain = chain;
        }

        public String getCacheId() {
            return this.cacheId;
        }

        public long getKey() {
            return this.key;
        }

        public Chain getChain() {
            return this.chain;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CHAIN_REPLICATION_OP;
        }

        @Override
        public ReplicationOp operation() {
            return ReplicationOp.CHAIN_REPLICATION_OP;
        }

        @Override
        public long concurrencyKey() {
            return this.key;
        }
    }

    public static class ClientIDTrackerMessage
    extends PassiveReplicationMessage {
        private final UUID clientId;
        private final long msgId;

        public ClientIDTrackerMessage(long msgId, UUID clientId) {
            this.msgId = msgId;
            this.clientId = clientId;
        }

        @Override
        public ReplicationOp operation() {
            return ReplicationOp.CLIENTID_TRACK_OP;
        }

        @Override
        public long getId() {
            return this.msgId;
        }

        @Override
        public UUID getClientId() {
            return this.clientId;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CLIENT_ID_TRACK_OP;
        }
    }

    public static enum ReplicationOp {
        CHAIN_REPLICATION_OP(41),
        CLIENTID_TRACK_OP(42),
        CLEAR_INVALIDATION_COMPLETE(43),
        INVALIDATION_COMPLETE(44),
        SERVER_STORE_LIFECYCLE_REPLICATION_OP(45);

        private final byte replicationOpCode;

        private ReplicationOp(byte replicationOpCode) {
            this.replicationOpCode = replicationOpCode;
        }

        public byte getReplicationOpCode() {
            return this.replicationOpCode;
        }

        public static ReplicationOp getReplicationOp(byte replicationOpCode) {
            switch (replicationOpCode) {
                case 41: {
                    return CHAIN_REPLICATION_OP;
                }
                case 42: {
                    return CLIENTID_TRACK_OP;
                }
                case 43: {
                    return CLEAR_INVALIDATION_COMPLETE;
                }
                case 44: {
                    return INVALIDATION_COMPLETE;
                }
                case 45: {
                    return SERVER_STORE_LIFECYCLE_REPLICATION_OP;
                }
            }
            throw new IllegalArgumentException("Replication operation not defined for : " + replicationOpCode);
        }
    }
}

