/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.common.internal.messages.LifeCycleMessageCodec;
import org.ehcache.clustered.common.internal.messages.LifecycleMessage;
import org.ehcache.clustered.common.internal.messages.PassiveReplicationMessage;
import org.ehcache.clustered.common.internal.messages.PassiveReplicationMessageCodec;
import org.ehcache.clustered.common.internal.messages.ResponseCodec;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpCodec;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpCodec;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.Enm;

public class EhcacheCodec
implements MessageCodec<EhcacheEntityMessage, EhcacheEntityResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheCodec.class);
    static final Struct OP_CODE_DECODER = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).build();
    private static final MessageCodec<EhcacheEntityMessage, EhcacheEntityResponse> SERVER_INSTANCE = new EhcacheCodec(new ServerStoreOpCodec(), new LifeCycleMessageCodec(), new StateRepositoryOpCodec(), new ResponseCodec(), new PassiveReplicationMessageCodec());
    private final ServerStoreOpCodec serverStoreOpCodec;
    private final LifeCycleMessageCodec lifeCycleMessageCodec;
    private final StateRepositoryOpCodec stateRepositoryOpCodec;
    private final ResponseCodec responseCodec;
    private final PassiveReplicationMessageCodec passiveReplicationMessageCodec;

    public static MessageCodec<EhcacheEntityMessage, EhcacheEntityResponse> messageCodec() {
        return SERVER_INSTANCE;
    }

    EhcacheCodec(ServerStoreOpCodec serverStoreOpCodec, LifeCycleMessageCodec lifeCycleMessageCodec, StateRepositoryOpCodec stateRepositoryOpCodec, ResponseCodec responseCodec, PassiveReplicationMessageCodec passiveReplicationMessageCodec) {
        this.serverStoreOpCodec = serverStoreOpCodec;
        this.lifeCycleMessageCodec = lifeCycleMessageCodec;
        this.stateRepositoryOpCodec = stateRepositoryOpCodec;
        this.responseCodec = responseCodec;
        this.passiveReplicationMessageCodec = passiveReplicationMessageCodec;
    }

    @Override
    public byte[] encodeMessage(EhcacheEntityMessage message) {
        if (!(message instanceof EhcacheOperationMessage)) {
            throw new AssertionError((Object)("Unexpected message type " + message.getClass()));
        }
        EhcacheOperationMessage operationMessage = (EhcacheOperationMessage)message;
        if (EhcacheMessageType.isLifecycleMessage(operationMessage.getMessageType())) {
            return this.lifeCycleMessageCodec.encode((LifecycleMessage)operationMessage);
        }
        if (EhcacheMessageType.isStoreOperationMessage(operationMessage.getMessageType())) {
            return this.serverStoreOpCodec.encode((ServerStoreOpMessage)operationMessage);
        }
        if (EhcacheMessageType.isStateRepoOperationMessage(operationMessage.getMessageType())) {
            return this.stateRepositoryOpCodec.encode((StateRepositoryOpMessage)operationMessage);
        }
        if (EhcacheMessageType.isPassiveSynchroMessage(operationMessage.getMessageType())) {
            return this.passiveReplicationMessageCodec.encode((PassiveReplicationMessage)operationMessage);
        }
        throw new AssertionError((Object)("Unknown message type: " + (Object)((Object)operationMessage.getMessageType())));
    }

    @Override
    public EhcacheEntityMessage decodeMessage(byte[] payload) throws MessageCodecException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(payload);
        Enm opCodeEnm = OP_CODE_DECODER.decoder(byteBuffer).enm("opCode");
        if (!opCodeEnm.isFound()) {
            throw new AssertionError((Object)"Got a message without an opCode");
        }
        if (!opCodeEnm.isValid()) {
            LOGGER.warn("Received message with unknown operation code - more recent version at the other end?");
            return null;
        }
        byteBuffer.rewind();
        EhcacheMessageType opCode = (EhcacheMessageType)((Object)opCodeEnm.get());
        if (EhcacheMessageType.isLifecycleMessage(opCode)) {
            return this.lifeCycleMessageCodec.decode(opCode, byteBuffer);
        }
        if (EhcacheMessageType.isStoreOperationMessage(opCode)) {
            return this.serverStoreOpCodec.decode(opCode, byteBuffer);
        }
        if (EhcacheMessageType.isStateRepoOperationMessage(opCode)) {
            return this.stateRepositoryOpCodec.decode(opCode, byteBuffer);
        }
        if (EhcacheMessageType.isPassiveSynchroMessage(opCode)) {
            return this.passiveReplicationMessageCodec.decode(opCode, byteBuffer);
        }
        throw new UnsupportedOperationException("Undefined message code: " + opCodeEnm);
    }

    @Override
    public byte[] encodeResponse(EhcacheEntityResponse response) throws MessageCodecException {
        return this.responseCodec.encode(response);
    }

    @Override
    public EhcacheEntityResponse decodeResponse(byte[] payload) throws MessageCodecException {
        return this.responseCodec.decode(payload);
    }
}

