/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection.entity;

import com.tc.exception.EntityReferencedException;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.object.ClientEntityManager;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.ExceptionUtils;
import com.tc.util.Assert;
import com.tc.util.Util;
import java.util.concurrent.atomic.AtomicLong;
import org.terracotta.connection.entity.Entity;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityClientService;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;

public class TerracottaEntityRef<T extends Entity, C>
implements EntityRef<T, C> {
    private final TCLogger logger = TCLogging.getLogger(TerracottaEntityRef.class);
    private final ClientEntityManager entityManager;
    private final Class<T> type;
    private final long version;
    private final String name;
    private final EntityClientService<T, C, ? extends EntityMessage, ? extends EntityResponse> entityClientService;
    private final AtomicLong nextClientInstanceID;

    public TerracottaEntityRef(ClientEntityManager entityManager, Class<T> type, long version, String name, EntityClientService<T, C, ? extends EntityMessage, ? extends EntityResponse> entityClientService, AtomicLong clientIds) {
        this.entityManager = entityManager;
        this.type = type;
        this.version = version;
        this.name = name;
        this.entityClientService = entityClientService;
        this.nextClientInstanceID = clientIds;
    }

    @Override
    public synchronized T fetchEntity() throws EntityNotFoundException, EntityVersionMismatchException {
        EntityClientEndpoint endpoint = null;
        try {
            ClientInstanceID clientInstanceID = new ClientInstanceID(this.nextClientInstanceID.getAndIncrement());
            EntityDescriptor entityDescriptor = new EntityDescriptor(this.getEntityID(), clientInstanceID, this.version);
            endpoint = this.entityManager.fetchEntity(entityDescriptor, this.entityClientService.getMessageCodec(), null);
        }
        catch (EntityException e) {
            if (e instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)e;
            }
            if (e instanceof EntityVersionMismatchException) {
                throw (EntityVersionMismatchException)e;
            }
            throw Assert.failure("Unsupported exception type returned to fetch", e);
        }
        catch (Throwable t) {
            Util.printLogAndRethrowError(t, this.logger);
        }
        if (endpoint == null) {
            Assert.assertNotNull(endpoint);
        }
        return this.entityClientService.create(endpoint);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private EntityID getEntityID() {
        return new EntityID(this.type.getName(), this.name);
    }

    @Override
    public void create(C configuration) throws EntityNotProvidedException, EntityAlreadyExistsException, EntityVersionMismatchException {
        EntityID entityID = this.getEntityID();
        try {
            this.entityManager.createEntity(entityID, this.version, this.entityClientService.serializeConfiguration(configuration)).get();
        }
        catch (EntityException e) {
            e = ExceptionUtils.addLocalStackTraceToEntityException(e);
            if (e instanceof EntityNotProvidedException) {
                throw (EntityNotProvidedException)e;
            }
            if (e instanceof EntityAlreadyExistsException) {
                throw (EntityAlreadyExistsException)e;
            }
            if (e instanceof EntityVersionMismatchException) {
                throw (EntityVersionMismatchException)e;
            }
            throw Assert.failure("Unsupported exception type returned to create", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public C reconfigure(C configuration) throws EntityException {
        EntityID entityID = this.getEntityID();
        try {
            return this.entityClientService.deserializeConfiguration(this.entityManager.reconfigureEntity(entityID, this.version, this.entityClientService.serializeConfiguration(configuration)).get());
        }
        catch (EntityException e) {
            throw ExceptionUtils.addLocalStackTraceToEntityException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean destroy() throws EntityNotFoundException {
        try {
            return this.destroyEntity();
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    private boolean destroyEntity() throws EntityNotFoundException, InterruptedException {
        boolean success;
        block3: {
            EntityID entityID = this.getEntityID();
            InvokeFuture<byte[]> future = this.entityManager.destroyEntity(entityID, this.version);
            success = false;
            try {
                future.get();
                success = true;
            }
            catch (EntityException e) {
                if (e instanceof EntityNotFoundException) {
                    throw (EntityNotFoundException)e;
                }
                if (!(e instanceof EntityReferencedException)) break block3;
                success = false;
            }
        }
        return success;
    }
}

