/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management.opentypes.adapters;

import java.util.ArrayList;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class ClassCreationCount
implements Comparable<ClassCreationCount> {
    private static final String COMPOSITE_TYPE_NAME = "ObjectCreationCountPerClass";
    private static final String COMPOSITE_TYPE_DESCRIPTION = "Number of objects created per class";
    private static final String[] ITEM_NAMES = new String[]{"className", "objectCreationCount"};
    private static final String[] ITEM_DESCRIPTIONS = new String[]{"className", "objectCreationCount"};
    private static final OpenType<?>[] ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
    private static final CompositeType COMPOSITE_TYPE;
    private static final String TABULAR_TYPE_NAME = "ObjectCreationCountByClass";
    private static final String TABULAR_TYPE_DESCRIPTION = "Object creation count by class";
    private static final String[] INDEX_NAMES;
    private static final TabularType TABULAR_TYPE;
    private final String className;
    private final Integer count;

    public ClassCreationCount(String className, Integer count) {
        this.className = className;
        this.count = count;
    }

    public String getClassName() {
        return this.className;
    }

    public Integer getCount() {
        return this.count;
    }

    public ClassCreationCount(CompositeData cData) {
        this.className = (String)cData.get(ITEM_NAMES[0]);
        this.count = (Integer)cData.get(ITEM_NAMES[1]);
    }

    public CompositeData toCompositeData() {
        try {
            return new CompositeDataSupport(COMPOSITE_TYPE, ITEM_NAMES, new Object[]{this.className, this.count});
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public static TabularData newTabularDataInstance() {
        return new TabularDataSupport(TABULAR_TYPE);
    }

    public static ClassCreationCount[] fromTabularData(TabularData tabularData) {
        ArrayList<ClassCreationCount> countList = new ArrayList<ClassCreationCount>(tabularData.size());
        for (Object data : tabularData.values()) {
            countList.add(new ClassCreationCount((CompositeData)data));
        }
        ClassCreationCount[] counts = new ClassCreationCount[countList.size()];
        countList.toArray(counts);
        return counts;
    }

    @Override
    public int compareTo(ClassCreationCount other) {
        int result = this.count.compareTo(other.count);
        return result != 0 ? result : this.className.compareTo(other.className);
    }

    static {
        INDEX_NAMES = new String[]{"className"};
        try {
            COMPOSITE_TYPE = new CompositeType(COMPOSITE_TYPE_NAME, COMPOSITE_TYPE_DESCRIPTION, ITEM_NAMES, ITEM_DESCRIPTIONS, ITEM_TYPES);
            TABULAR_TYPE = new TabularType(TABULAR_TYPE_NAME, TABULAR_TYPE_DESCRIPTION, COMPOSITE_TYPE, INDEX_NAMES);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }
}

