/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.service;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import org.ehcache.CachePersistenceException;
import org.ehcache.clustered.client.config.ClusteredResourcePool;
import org.ehcache.clustered.client.config.ClusteredResourceType;
import org.ehcache.clustered.client.config.ClusteringServiceConfiguration;
import org.ehcache.clustered.client.internal.EhcacheClientEntity;
import org.ehcache.clustered.client.internal.EhcacheClientEntityFactory;
import org.ehcache.clustered.client.internal.EhcacheEntityCreationException;
import org.ehcache.clustered.client.internal.EhcacheEntityNotFoundException;
import org.ehcache.clustered.client.internal.EhcacheEntityValidationException;
import org.ehcache.clustered.client.internal.config.ExperimentalClusteringServiceConfiguration;
import org.ehcache.clustered.client.internal.service.AbstractClientEntityFactory;
import org.ehcache.clustered.client.internal.service.ClusteredStateRepository;
import org.ehcache.clustered.client.internal.service.ClusteredTierCreationException;
import org.ehcache.clustered.client.internal.service.ClusteredTierDestructionException;
import org.ehcache.clustered.client.internal.service.ClusteredTierException;
import org.ehcache.clustered.client.internal.service.ClusteredTierReleaseException;
import org.ehcache.clustered.client.internal.store.EventualServerStoreProxy;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.StrongServerStoreProxy;
import org.ehcache.clustered.client.service.ClientEntityFactory;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.client.service.EntityBusyException;
import org.ehcache.clustered.client.service.EntityService;
import org.ehcache.clustered.common.Consistency;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.exceptions.InvalidStoreException;
import org.ehcache.clustered.common.internal.messages.ServerStoreMessageFactory;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourceType;
import org.ehcache.core.spi.store.Store;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.ehcache.spi.persistence.PersistableResourceService;
import org.ehcache.spi.persistence.StateRepository;
import org.ehcache.spi.service.MaintainableService;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionFactory;
import org.terracotta.connection.entity.Entity;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityNotFoundException;

class DefaultClusteringService
implements ClusteringService,
EntityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClusteringService.class);
    static final String CONNECTION_PREFIX = "Ehcache:";
    private final ClusteringServiceConfiguration configuration;
    private final URI clusterUri;
    private final String entityIdentifier;
    private final ConcurrentMap<String, ClusteredSpace> knownPersistenceSpaces = new ConcurrentHashMap();
    private final EhcacheClientEntity.Timeouts operationTimeouts;
    private volatile Connection clusterConnection;
    private EhcacheClientEntityFactory entityFactory;
    private EhcacheClientEntity entity;
    private volatile boolean inMaintenance = false;

    DefaultClusteringService(ClusteringServiceConfiguration configuration) {
        this.configuration = configuration;
        URI ehcacheUri = configuration.getClusterUri();
        this.clusterUri = DefaultClusteringService.extractClusterUri(ehcacheUri);
        this.entityIdentifier = this.clusterUri.relativize(ehcacheUri).getPath();
        EhcacheClientEntity.Timeouts.Builder timeoutsBuilder = EhcacheClientEntity.Timeouts.builder();
        timeoutsBuilder.setReadOperationTimeout(configuration.getReadOperationTimeout());
        if (configuration instanceof ExperimentalClusteringServiceConfiguration) {
            ExperimentalClusteringServiceConfiguration experimentalConfiguration = (ExperimentalClusteringServiceConfiguration)((Object)configuration);
            if (experimentalConfiguration.getMutativeOperationTimeout() != null) {
                timeoutsBuilder.setMutativeOperationTimeout(experimentalConfiguration.getMutativeOperationTimeout());
            }
            if (experimentalConfiguration.getLifecycleOperationTimeout() != null) {
                timeoutsBuilder.setLifecycleOperationTimeout(experimentalConfiguration.getLifecycleOperationTimeout());
            }
        }
        this.operationTimeouts = timeoutsBuilder.build();
    }

    private static URI extractClusterUri(URI uri) {
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ClusteringServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public <E extends Entity, C> ClientEntityFactory<E, C> newClientEntityFactory(String entityIdentifier, Class<E> entityType, long entityVersion, C configuration) {
        return new AbstractClientEntityFactory<E, C>(entityIdentifier, entityType, entityVersion, configuration){

            @Override
            protected Connection getConnection() {
                if (!DefaultClusteringService.this.isConnected()) {
                    throw new IllegalStateException(this.getClass().getSimpleName() + " not started.");
                }
                return DefaultClusteringService.this.clusterConnection;
            }
        };
    }

    @Override
    public boolean isConnected() {
        return this.clusterConnection != null;
    }

    public void start(ServiceProvider<Service> serviceProvider) {
        block6: {
            this.initClusterConnection();
            this.createEntityFactory();
            try {
                if (this.configuration.isAutoCreate()) {
                    this.entity = this.autoCreateEntity();
                    break block6;
                }
                try {
                    this.entity = this.entityFactory.retrieve(this.entityIdentifier, this.configuration.getServerConfiguration());
                }
                catch (EntityNotFoundException e) {
                    throw new IllegalStateException("The clustered tier manager '" + this.entityIdentifier + "' does not exist." + " Please review your configuration.", e);
                }
                catch (TimeoutException e) {
                    throw new RuntimeException("Could not connect to the clustered tier manager '" + this.entityIdentifier + "'; retrieve operation timed out", e);
                }
            }
            catch (RuntimeException e) {
                this.entityFactory = null;
                this.closeConnection();
                throw e;
            }
        }
    }

    public void startForMaintenance(ServiceProvider<? super MaintainableService> serviceProvider, MaintainableService.MaintenanceScope maintenanceScope) {
        this.initClusterConnection();
        this.createEntityFactory();
        if (maintenanceScope == MaintainableService.MaintenanceScope.CACHE_MANAGER && !this.entityFactory.acquireLeadership(this.entityIdentifier)) {
            this.entityFactory = null;
            this.closeConnection();
            throw new IllegalStateException("Couldn't acquire cluster-wide maintenance lease");
        }
        this.inMaintenance = true;
    }

    private void createEntityFactory() {
        this.entityFactory = new EhcacheClientEntityFactory(this.clusterConnection, this.operationTimeouts);
    }

    private void initClusterConnection() {
        try {
            Properties properties = new Properties();
            properties.put("connection.name", CONNECTION_PREFIX + this.entityIdentifier);
            properties.put("connection.timeout", Long.toString(this.operationTimeouts.getLifecycleOperationTimeout().toMillis()));
            this.clusterConnection = ConnectionFactory.connect(this.clusterUri, properties);
        }
        catch (ConnectionException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Loose catch block
     */
    private EhcacheClientEntity autoCreateEntity() throws EhcacheEntityValidationException, IllegalStateException {
        while (true) {
            try {
                this.entityFactory.create(this.entityIdentifier, this.configuration.getServerConfiguration());
            }
            catch (EhcacheEntityCreationException e) {
                throw new IllegalStateException("Could not create the clustered tier manager '" + this.entityIdentifier + "'.", e);
            }
            catch (EntityAlreadyExistsException e) {
            }
            catch (EntityBusyException e) {
            }
            catch (TimeoutException e) {
                throw new RuntimeException("Could not create the clustered tier manager '" + this.entityIdentifier + "'; create operation timed out", e);
            }
            try {
                return this.entityFactory.retrieve(this.entityIdentifier, this.configuration.getServerConfiguration());
            }
            catch (EntityNotFoundException e) {
                continue;
            }
            break;
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Could not connect to the clustered tier manager '" + this.entityIdentifier + "'; retrieve operation timed out", e);
        }
    }

    public void stop() {
        LOGGER.info("stop called for clustered tiers on {}", (Object)this.clusterUri);
        this.entityFactory = null;
        this.inMaintenance = false;
        this.entity = null;
        this.closeConnection();
    }

    public void destroyAll() throws CachePersistenceException {
        if (!this.inMaintenance) {
            throw new IllegalStateException("Maintenance mode required");
        }
        LOGGER.info("destroyAll called for clustered tiers on {}", (Object)this.clusterUri);
        try {
            this.entityFactory.destroy(this.entityIdentifier);
        }
        catch (EhcacheEntityNotFoundException e) {
            throw new CachePersistenceException("Clustered tiers on " + this.clusterUri + " not found", (Throwable)e);
        }
        catch (EntityBusyException e) {
            throw new CachePersistenceException("Can not delete clustered tiers on " + this.clusterUri, (Throwable)e);
        }
    }

    public boolean handlesResourceType(ResourceType<?> resourceType) {
        return Arrays.asList(ClusteredResourceType.Types.values()).contains(resourceType);
    }

    public PersistableResourceService.PersistenceSpaceIdentifier getPersistenceSpaceIdentifier(String name, CacheConfiguration<?, ?> config) throws CachePersistenceException {
        ClusteredSpace clusteredSpace = (ClusteredSpace)this.knownPersistenceSpaces.get(name);
        if (clusteredSpace != null) {
            return clusteredSpace.identifier;
        }
        DefaultClusterCacheIdentifier cacheIdentifier = new DefaultClusterCacheIdentifier(name);
        clusteredSpace = this.knownPersistenceSpaces.putIfAbsent(name, new ClusteredSpace(cacheIdentifier));
        if (clusteredSpace == null) {
            return cacheIdentifier;
        }
        return clusteredSpace.identifier;
    }

    public void releasePersistenceSpaceIdentifier(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier) throws CachePersistenceException {
        ClusteringService.ClusteredCacheIdentifier clusterCacheIdentifier = (ClusteringService.ClusteredCacheIdentifier)identifier;
        if (this.knownPersistenceSpaces.remove(clusterCacheIdentifier.getId()) == null) {
            throw new CachePersistenceException("Unknown identifier: " + clusterCacheIdentifier);
        }
    }

    public StateRepository getStateRepositoryWithin(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier, String name) throws CachePersistenceException {
        ClusteringService.ClusteredCacheIdentifier clusterCacheIdentifier = (ClusteringService.ClusteredCacheIdentifier)identifier;
        ClusteredSpace clusteredSpace = (ClusteredSpace)this.knownPersistenceSpaces.get(clusterCacheIdentifier.getId());
        if (clusteredSpace == null) {
            throw new CachePersistenceException("Clustered space not found for identifier: " + clusterCacheIdentifier);
        }
        ConcurrentMap stateRepositories = clusteredSpace.stateRepositories;
        ClusteredStateRepository currentRepo = (ClusteredStateRepository)stateRepositories.get(name);
        if (currentRepo != null) {
            return currentRepo;
        }
        ClusteredStateRepository newRepo = new ClusteredStateRepository(clusterCacheIdentifier, name, this.entity);
        currentRepo = stateRepositories.putIfAbsent(name, newRepo);
        if (currentRepo == null) {
            return newRepo;
        }
        return currentRepo;
    }

    private void checkStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException(this.getClass().getName() + " should be started to call destroy");
        }
    }

    public void destroy(String name) throws CachePersistenceException {
        this.checkStarted();
        if (this.entity == null) {
            try {
                this.entity = this.entityFactory.retrieve(this.entityIdentifier, this.configuration.getServerConfiguration());
            }
            catch (EntityNotFoundException e) {
            }
            catch (TimeoutException e) {
                throw new CachePersistenceException("Could not connect to the clustered tier manager '" + this.entityIdentifier + "'; retrieve operation timed out", (Throwable)e);
            }
        }
        try {
            if (this.entity != null) {
                this.entity.destroyCache(name);
            }
        }
        catch (ClusteredTierDestructionException e) {
            throw new CachePersistenceException(e.getMessage() + " (on " + this.clusterUri + ")", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new CachePersistenceException("Could not destroy clustered tier '" + name + "' on " + this.clusterUri + "; destroy operation timed out" + this.clusterUri, (Throwable)e);
        }
    }

    protected boolean isStarted() {
        return this.entityFactory != null;
    }

    @Override
    public <K, V> ServerStoreProxy getServerStoreProxy(ClusteringService.ClusteredCacheIdentifier cacheIdentifier, Store.Configuration<K, V> storeConfig, Consistency configuredConsistency) throws CachePersistenceException {
        String cacheId = cacheIdentifier.getId();
        if (configuredConsistency == null) {
            throw new NullPointerException("Consistency cannot be null");
        }
        ClusteredResourcePool clusteredResourcePool = null;
        for (ClusteredResourceType<? extends ClusteredResourcePool> type : ClusteredResourceType.Types.values()) {
            ClusteredResourcePool pool = (ClusteredResourcePool)storeConfig.getResourcePools().getPoolForResource(type);
            if (pool == null) continue;
            if (clusteredResourcePool != null) {
                throw new IllegalStateException("At most one clustered resource supported for a cache");
            }
            clusteredResourcePool = pool;
        }
        if (clusteredResourcePool == null) {
            throw new IllegalStateException("A clustered resource is required for a clustered cache");
        }
        ServerStoreConfiguration clientStoreConfiguration = new ServerStoreConfiguration(clusteredResourcePool.getPoolAllocation(), storeConfig.getKeyType().getName(), storeConfig.getValueType().getName(), null, null, storeConfig.getKeySerializer() == null ? null : storeConfig.getKeySerializer().getClass().getName(), storeConfig.getValueSerializer() == null ? null : storeConfig.getValueSerializer().getClass().getName(), configuredConsistency);
        try {
            if (this.configuration.isAutoCreate()) {
                try {
                    this.entity.createCache(cacheId, clientStoreConfiguration);
                }
                catch (ClusteredTierCreationException e) {
                    if (!(e.getCause() instanceof InvalidStoreException)) {
                        throw e;
                    }
                    this.entity.validateCache(cacheId, clientStoreConfiguration);
                }
            } else {
                this.entity.validateCache(cacheId, clientStoreConfiguration);
            }
        }
        catch (ClusteredTierException e) {
            throw new CachePersistenceException("Unable to create clustered tier proxy '" + cacheIdentifier.getId() + "' for entity '" + this.entityIdentifier + "'", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new CachePersistenceException("Unable to create clustered tier proxy '" + cacheIdentifier.getId() + "' for entity '" + this.entityIdentifier + "'; validate operation timed out", (Throwable)e);
        }
        ServerStoreMessageFactory messageFactory = new ServerStoreMessageFactory(cacheId, this.entity.getClientId());
        switch (configuredConsistency) {
            case STRONG: {
                return new StrongServerStoreProxy(messageFactory, this.entity);
            }
            case EVENTUAL: {
                return new EventualServerStoreProxy(messageFactory, this.entity);
            }
        }
        throw new AssertionError((Object)("Unknown consistency : " + (Object)((Object)configuredConsistency)));
    }

    @Override
    public void releaseServerStoreProxy(ServerStoreProxy storeProxy) {
        String cacheId = storeProxy.getCacheId();
        try {
            this.entity.releaseCache(cacheId);
        }
        catch (ClusteredTierReleaseException e) {
            throw new IllegalStateException(e);
        }
        catch (TimeoutException e) {
            LOGGER.warn("Timed out trying to release clustered tier proxy for '{}'", (Object)cacheId, (Object)e);
        }
    }

    private void closeConnection() {
        Connection conn = this.clusterConnection;
        this.clusterConnection = null;
        if (conn != null) {
            try {
                conn.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error closing cluster connection: " + e);
            }
        }
    }

    private static class ClusteredSpace {
        private final ClusteringService.ClusteredCacheIdentifier identifier;
        private final ConcurrentMap<String, ClusteredStateRepository> stateRepositories;

        ClusteredSpace(ClusteringService.ClusteredCacheIdentifier identifier) {
            this.identifier = identifier;
            this.stateRepositories = new ConcurrentHashMap();
        }
    }

    private static class DefaultClusterCacheIdentifier
    implements ClusteringService.ClusteredCacheIdentifier {
        private final String id;

        DefaultClusterCacheIdentifier(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public Class<ClusteringService> getServiceType() {
            return ClusteringService.class;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + this.id;
        }
    }
}

