/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.concurrent;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.text.StringUtils;
import com.tc.util.concurrent.PooledTimer;
import com.tc.util.concurrent.TaskRunner;
import com.tc.util.concurrent.ThreadFactoryBuilder;
import com.tc.util.concurrent.Timer;
import com.tc.util.concurrent.TimerNamedRunnable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ScheduledNamedTaskRunner
extends ScheduledThreadPoolExecutor
implements TaskRunner {
    private static final TCLogger logger = TCLogging.getLogger(ScheduledNamedTaskRunner.class);
    private final ThreadLocal<String> initialThreadName = new ThreadLocal();
    private final Map<Timer, Set<Future<?>>> timerTasks = new HashMap();

    public ScheduledNamedTaskRunner(int corePoolSize) {
        super(corePoolSize);
    }

    public ScheduledNamedTaskRunner(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public ScheduledNamedTaskRunner(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
    }

    public ScheduledNamedTaskRunner(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    public ScheduledNamedTaskRunner(int corePoolSize, ThreadGroup threadGroup) {
        super(corePoolSize, ScheduledNamedTaskRunner.newThreadFactory(threadGroup));
    }

    protected void handleUncaughtException(Throwable e) {
        Thread t = Thread.currentThread();
        t.getUncaughtExceptionHandler().uncaughtException(t, e);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (r instanceof NamedRunnableScheduledFuture) {
            NamedRunnableScheduledFuture namedRunnable = (NamedRunnableScheduledFuture)r;
            if (StringUtils.isNotBlank(namedRunnable.getName())) {
                this.initialThreadName.set(t.getName());
                t.setName(namedRunnable.getName());
            }
            this.registerTimerTask(namedRunnable);
        }
        super.beforeExecute(t, r);
    }

    private synchronized void registerTimerTask(NamedRunnableScheduledFuture<?> namedRunnable) {
        Timer timer = namedRunnable.getTimer();
        Set<Future<?>> tasks = this.timerTasks.get(timer);
        if (tasks == null) {
            tasks = new HashSet();
            this.timerTasks.put(timer, tasks);
        }
        tasks.add(namedRunnable);
    }

    private synchronized void unregisterTimerTask(NamedRunnableScheduledFuture<?> namedRunnable) {
        Timer timer = namedRunnable.getTimer();
        Set<Future<?>> tasks = this.timerTasks.get(timer);
        if (tasks != null) {
            tasks.remove(namedRunnable);
            if (tasks.isEmpty()) {
                this.timerTasks.remove(timer);
            }
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable e) {
        super.afterExecute(r, e);
        Thread t = Thread.currentThread();
        if (e == null && r instanceof Future) {
            try {
                Future future = (Future)((Object)r);
                if (future.isDone()) {
                    ScheduledNamedTaskRunner.uninterruptedGet(future);
                }
            }
            catch (CancellationException ce) {
                logger.debug("A task executed by '" + t.getName() + "' thread has been gracefully cancelled");
            }
            catch (ExecutionException ee) {
                e = ee.getCause();
            }
        }
        if (e != null) {
            this.handleUncaughtException(e);
        }
        if (r instanceof NamedRunnableScheduledFuture) {
            NamedRunnableScheduledFuture namedRunnable = (NamedRunnableScheduledFuture)r;
            if (StringUtils.isNotBlank(namedRunnable.getName())) {
                t.setName(this.initialThreadName.get());
                this.initialThreadName.remove();
            }
            this.unregisterTimerTask(namedRunnable);
        }
    }

    private static void uninterruptedGet(Future<?> future) throws ExecutionException {
        while (true) {
            try {
                future.get();
            }
            catch (InterruptedException ie) {
                logger.debug("A task executed by '" + Thread.currentThread().getName() + "' thread has been interrupted", ie);
                continue;
            }
            break;
        }
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        if (runnable instanceof TimerNamedRunnable) {
            TimerNamedRunnable namedRunnable = (TimerNamedRunnable)runnable;
            return new NamedRunnableScheduledFuture(namedRunnable, task);
        }
        return super.decorateTask(runnable, task);
    }

    private static ThreadFactory newThreadFactory(ThreadGroup threadGroup) {
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder();
        if (threadGroup != null) {
            builder.setThreadFactory(new ThreadGroupAwareFactory(threadGroup));
        }
        builder.setDaemon(true).setNameFormat("task-runner-thread-%s").setPriority(5);
        return builder.build();
    }

    @Override
    public Timer newTimer() {
        return this.newTimer(null);
    }

    @Override
    public Timer newTimer(String name) {
        if (this.isShutdown()) {
            throw new IllegalStateException("Cannot create a timer - the parent task runner has been already shut down");
        }
        return new PooledTimer(name, this);
    }

    @Override
    public synchronized void cancelTimer(Timer timer) {
        Set<Future<?>> tasks = this.timerTasks.remove(timer);
        if (tasks != null) {
            for (Future<?> task : tasks) {
                task.cancel(false);
            }
            this.purge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        super.shutdownNow();
        boolean timedout = false;
        try {
            timedout = !this.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (timedout) {
                logger.warn("Not all TaskRunner threads gracefully finished execution");
            }
        }
        this.initialThreadName.remove();
        ScheduledNamedTaskRunner scheduledNamedTaskRunner = this;
        synchronized (scheduledNamedTaskRunner) {
            this.timerTasks.clear();
        }
    }

    private final class NamedRunnableScheduledFuture<V>
    implements RunnableScheduledFuture<V>,
    TimerNamedRunnable {
        private final TimerNamedRunnable namedRunnable;
        private final RunnableScheduledFuture<V> target;

        private NamedRunnableScheduledFuture(TimerNamedRunnable namedRunnable, RunnableScheduledFuture<V> target) {
            this.namedRunnable = namedRunnable;
            this.target = target;
        }

        @Override
        public String getName() {
            return this.namedRunnable.getName();
        }

        @Override
        public Timer getTimer() {
            return this.namedRunnable.getTimer();
        }

        @Override
        public boolean isPeriodic() {
            return this.target.isPeriodic();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.target.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.target.compareTo(o);
        }

        @Override
        public void run() {
            this.target.run();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.target.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.target.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.target.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.target.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.target.get(timeout, unit);
        }
    }

    private static final class ThreadGroupAwareFactory
    implements ThreadFactory {
        private final ThreadGroup group;

        private ThreadGroupAwareFactory(ThreadGroup group) {
            this.group = group;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(this.group, r);
        }
    }
}

