/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management.beans;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.management.AbstractTerracottaMBean;
import com.tc.management.L1Info;
import com.tc.management.TCClient;
import com.tc.management.beans.L1DumperMBean;
import javax.management.NotCompliantMBeanException;

public class L1Dumper
extends AbstractTerracottaMBean
implements L1DumperMBean {
    private static final boolean DEBUG = false;
    private static final TCLogger logger = TCLogging.getLogger(L1Dumper.class);
    private static final int DEFAULT_THREAD_DUMP_COUNT = 3;
    private static final long DEFAULT_THREAD_DUMP_INTERVAL = 1000L;
    public int threadDumpCount = 3;
    public long threadDumpInterval = 1000L;
    private final TCClient tclient;
    private final L1Info l1Info;

    public L1Dumper(TCClient tclient, L1Info l1InfoBean) throws NotCompliantMBeanException {
        super(L1DumperMBean.class, false);
        this.tclient = tclient;
        this.l1Info = l1InfoBean;
    }

    @Override
    public void doClientDump() {
        logger.info("Client dump: ");
        this.tclient.dump();
        try {
            this.doThreadDump();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setThreadDumpCount(int count) {
        this.threadDumpCount = count;
    }

    @Override
    public void setThreadDumpInterval(long interval) {
        this.threadDumpInterval = interval;
    }

    @Override
    public void doThreadDump() throws Exception {
        this.debugPrintln("ThreadDumping:  count=[" + this.threadDumpCount + "] interval=[" + this.threadDumpInterval + "]");
        for (int i = 0; i < this.threadDumpCount; ++i) {
            this.l1Info.takeThreadDump(System.currentTimeMillis());
            Thread.sleep(this.threadDumpInterval);
        }
    }

    @Override
    public void reset() {
    }

    private void debugPrintln(String s) {
    }
}

